package ar.com.sdd.mercadopago.entity.customer;

/**
 * Mercado Pago SDK
 * Customer Address Country class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Country {

    private String id = null;
    private String name = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "Country ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((name != null) ? "name=" + name : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Country country = (Country) o;

        if (id != null ? !id.equals(country.id) : country.id != null) return false;
        return name != null ? name.equals(country.name) : country.name == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }
}
