package ar.com.sdd.mercadopago.entity.customer;

/**
 * Mercado Pago SDK
 * Customer Address digest class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class DefaultAddress {

    private String id = null;
    private String zipCode = null;
    private String streetName = null;
    private String streetNumber = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getZipCode() {
        return zipCode;
    }

    public DefaultAddress setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public String getStreetName() {
        return streetName;
    }

    public DefaultAddress setStreetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    public String getStreetNumber() {
        return streetNumber;
    }

    public DefaultAddress setStreetNumber(String streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    @Override
    public String toString() {
        return "DefaultAddress ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((zipCode != null) ? "zipCode=" + zipCode + ", " : "")
                + ((streetName != null) ? "streetName=" + streetName + ", " : "")
                + ((streetNumber != null) ? "streetNumber=" + streetNumber : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DefaultAddress that = (DefaultAddress) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (zipCode != null ? !zipCode.equals(that.zipCode) : that.zipCode != null) return false;
        if (streetName != null ? !streetName.equals(that.streetName) : that.streetName != null) return false;
        return streetNumber != null ? streetNumber.equals(that.streetNumber) : that.streetNumber == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (zipCode != null ? zipCode.hashCode() : 0);
        result = 31 * result + (streetName != null ? streetName.hashCode() : 0);
        result = 31 * result + (streetNumber != null ? streetNumber.hashCode() : 0);
        return result;
    }
}
