package ar.com.sdd.mercadopago.entity.customer;

/**
 * Mercado Libre SDK
 * Customer Address Verification Shipment Error class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Error {

    private String code = null;
    private String description = null;
    private String field = null;


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getField() {
        return field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    public String toString() {
        return "Error ["
                + ((code != null) ? "code=" + code + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((field != null) ? "field=" + field : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Error error = (Error) o;

        if (code != null ? !code.equals(error.code) : error.code != null) return false;
        if (description != null ? !description.equals(error.description) : error.description != null) return false;
        return field != null ? field.equals(error.field) : error.field == null;
    }

    @Override
    public int hashCode() {
        int result = code != null ? code.hashCode() : 0;
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (field != null ? field.hashCode() : 0);
        return result;
    }
}
