package ar.com.sdd.mercadopago.entity.customer;

/**
 * Mercado Pago SDK
 * Customer Address State class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class State {

    private String id = null;
    private String name = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "State ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((name != null) ? "name=" + name : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        State state = (State) o;

        if (id != null ? !id.equals(state.id) : state.id != null) return false;
        return name != null ? name.equals(state.name) : state.name == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }
}
