package ar.com.sdd.mercadopago.entity.customer;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Mercado Pago SDK
 * Customer Address Verification class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Verification {

    private ArrayList<Shipment> shipments = null;

    public ArrayList<Shipment> getShipments() {
        return shipments;
    }

    public void setShipments(ArrayList<Shipment> shipments) {
        this.shipments = shipments;
    }

    @Override
    public String toString() {
        return "Verification ["
                + ((shipments != null) ? "shipments=" + Arrays.toString(shipments.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Verification that = (Verification) o;

        return shipments != null ? shipments.equals(that.shipments) : that.shipments == null;
    }

    @Override
    public int hashCode() {
        return shipments != null ? shipments.hashCode() : 0;
    }
}
