package ar.com.sdd.mercadopago.entity.customer.card;

/**
 * Mercado Pago SDK
 * Card Cardholder class
 * <p>
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Cardholder {

    private String name = null;
    private Identification identification = null;


    public String getName() {
        return name;
    }

    public Cardholder setName(String name) {
        this.name = name;
        return this;
    }

    public Identification getIdentification() {
        return identification;
    }

    public Cardholder setIdentification(Identification identification) {
        this.identification = identification;
        return this;
    }

    @Override
    public String toString() {
        return "Cardholder ["
                + ((name != null) ? "name=" + name + ", " : "")
                + ((identification != null) ? "identification=" + identification : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Cardholder that = (Cardholder) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        return identification != null ? identification.equals(that.identification) : that.identification == null;
    }

    @Override
    public int hashCode() {
        int result = name != null ? name.hashCode() : 0;
        result = 31 * result + (identification != null ? identification.hashCode() : 0);
        return result;
    }
}
