package ar.com.sdd.mercadopago.entity.customer.card;

/**
 * Mercado Pago SDK
 * Card Issuer class
 *
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class Issuer {

    private String id = null;
    private String name = null;


    public String getId() {
        return id;
    }

    public Issuer setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public Issuer setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return "Issuer ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((name != null) ? "name=" + name : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Issuer issuer = (Issuer) o;

        if (id != null ? !id.equals(issuer.id) : issuer.id != null) return false;
        return name != null ? name.equals(issuer.name) : issuer.name == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        return result;
    }
}
