package ar.com.sdd.mercadopago.entity.customer.card;

/**
 * Mercado Pago SDK
 * Card Security Code class
 *
 * Created by Eduardo Paoletta on 12/15/16.
 */
public class SecurityCode {

    private Integer length = null;
    private String cardLocation = null;


    public Integer getLength() {
        return length;
    }

    public SecurityCode setLength(Integer length) {
        this.length = length;
        return this;
    }

    public String getCardLocation() {
        return cardLocation;
    }

    public SecurityCode setCardLocation(String cardLocation) {
        this.cardLocation = cardLocation;
        return this;
    }

    @Override
    public String toString() {
        return "SecurityCode ["
                + ((length != null) ? "length=" + length + ", " : "")
                + ((cardLocation != null) ? "cardLocation=" + cardLocation : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        SecurityCode that = (SecurityCode) o;

        if (length != null ? !length.equals(that.length) : that.length != null) return false;
        return cardLocation != null ? cardLocation.equals(that.cardLocation) : that.cardLocation == null;
    }

    @Override
    public int hashCode() {
        int result = length != null ? length.hashCode() : 0;
        result = 31 * result + (cardLocation != null ? cardLocation.hashCode() : 0);
        return result;
    }
}
