package ar.com.sdd.mercadopago.entity.merchantorder;

/**
 * Mercado Pago SDK
 * Mechant Order Shipment Address class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
public class Address {

    private String zipCode = null;
    private String streetName = null;
    private Integer streetNumber = null;
    private String floor = null;
    private String apartment = null;


    public String getZipCode() {
        return zipCode;
    }

    public Address setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public String getStreetName() {
        return streetName;
    }

    public Address setStreetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    public Integer getStreetNumber() {
        return streetNumber;
    }

    public Address setStreetNumber(Integer streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    public String getFloor() {
        return floor;
    }

    public Address setFloor(String floor) {
        this.floor = floor;
        return this;
    }

    public String getApartment() {
        return apartment;
    }

    public Address setApartment(String apartment) {
        this.apartment = apartment;
        return this;
    }


    @Override
    public String toString() {
        return "Address ["
                + ((zipCode != null) ? "zipCode=" + zipCode + ", " : "")
                + ((streetName != null) ? "streetName=" + streetName + ", " : "")
                + ((streetNumber != null) ? "streetNumber=" + streetNumber + ", " : "")
                + ((floor != null) ? "floor=" + floor + ", " : "")
                + ((apartment != null) ? "apartment=" + apartment : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Address address = (Address) o;

        if (zipCode != null ? !zipCode.equals(address.zipCode) : address.zipCode != null) return false;
        if (streetName != null ? !streetName.equals(address.streetName) : address.streetName != null) return false;
        if (streetNumber != null ? !streetNumber.equals(address.streetNumber) : address.streetNumber != null) return false;
        if (floor != null ? !floor.equals(address.floor) : address.floor != null) return false;
        return apartment != null ? apartment.equals(address.apartment) : address.apartment == null;
    }

    @Override
    public int hashCode() {
        int result = zipCode != null ? zipCode.hashCode() : 0;
        result = 31 * result + (streetName != null ? streetName.hashCode() : 0);
        result = 31 * result + (streetNumber != null ? streetNumber.hashCode() : 0);
        result = 31 * result + (floor != null ? floor.hashCode() : 0);
        result = 31 * result + (apartment != null ? apartment.hashCode() : 0);
        return result;
    }
}
