package ar.com.sdd.mercadopago.entity.merchantorder;

/**
 * Mercado Pago SDK
 * Merchant Order Collector class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
public class Collector {

    private String id = null;
    private String email = null;
    private String nickname = null;

    public String getId() {
        return this.id;
    }

    public Collector setId(String id) {
        this.id = id;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Collector setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Collector setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Override
    public String toString() {
        return "Collector ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((nickname != null) ? "nickname=" + nickname : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Collector collector = (Collector) o;

        if (id != null ? !id.equals(collector.id) : collector.id != null) return false;
        if (email != null ? !email.equals(collector.email) : collector.email != null) return false;
        return nickname != null ? nickname.equals(collector.nickname) : collector.nickname == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (nickname != null ? nickname.hashCode() : 0);
        return result;
    }
}
