package ar.com.sdd.mercadopago.entity.merchantorder;

import java.util.Date;

/**
 * Mercado Pago MercadoPago
 * Merchant Order Shipment class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
public class Shipment {

    private Integer id = null;
    private String shipmentType = null;
    private String shipmentMode = null;
    private String pickingType = null;
    private String status = null;
    private String substatus = null;
    private Object items = null;
    private Date dateCreated = null;
    private Date lastModified = null;
    private Date dateFirstPrinted = null;
    private String serviceId = null;
    private Integer senderId = null;
    private Integer receiverId = null;
    private Address receiverAddress = null;


    public Integer getId() {
        return id;
    }

    public Shipment setId(Integer id) {
        this.id = id;
        return this;
    }

    public String getShipmentType() {
        return shipmentType;
    }

    public Shipment setShipmentType(String shipmentType) {
        this.shipmentType = shipmentType;
        return this;
    }

    public String getShipmentMode() {
        return shipmentMode;
    }

    public Shipment setShipmentMode(String shipmentMode) {
        this.shipmentMode = shipmentMode;
        return this;
    }

    public String getPickingType() {
        return pickingType;
    }

    public Shipment setPickingType(String pickingType) {
        this.pickingType = pickingType;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public Shipment setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getSubstatus() {
        return substatus;
    }

    public Shipment setSubstatus(String subStatus) {
        this.substatus = subStatus;
        return this;
    }

    public Object getItems() {
        return items;
    }

    public Shipment setItems(Object items) {
        this.items = items;
        return this;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public Shipment setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public Date getLastModified() {
        return lastModified;
    }

    public Shipment setLastModified(Date lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public Date getDateFirstPrinted() {
        return dateFirstPrinted;
    }

    public Shipment setDateFirstPrinted(Date dateFirstPrinted) {
        this.dateFirstPrinted = dateFirstPrinted;
        return this;
    }

    public String getServiceId() {
        return serviceId;
    }

    public Shipment setServiceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public Integer getSenderId() {
        return senderId;
    }

    public Shipment setSenderId(Integer senderId) {
        this.senderId = senderId;
        return this;
    }

    public Integer getReceiverId() {
        return receiverId;
    }

    public Shipment setReceiverId(Integer receiverId) {
        this.receiverId = receiverId;
        return this;
    }

    public Address getReceiverAddress() {
        return receiverAddress;
    }

    public Shipment setReceiverAddress(Address receiverAddress) {
        this.receiverAddress = receiverAddress;
        return this;
    }

    @Override
    public String toString() {
        return "Shipment ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((shipmentType != null) ? "shipmentType=" + shipmentType + ", " : "")
                + ((shipmentMode != null) ? "shipmentMode=" + shipmentMode + ", " : "")
                + ((pickingType != null) ? "pickingType=" + pickingType + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((substatus != null) ? "substatus=" + substatus + ", " : "")
                + ((items != null) ? "items=" + items + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((lastModified != null) ? "lastModified=" + lastModified + ", " : "")
                + ((dateFirstPrinted != null) ? "dateFirstPrinted=" + dateFirstPrinted + ", " : "")
                + ((serviceId != null) ? "serviceId=" + serviceId + ", " : "")
                + ((senderId != null) ? "senderId=" + senderId + ", " : "")
                + ((receiverId != null) ? "receiverId=" + receiverId + ", " : "")
                + ((receiverAddress != null) ? "receiverAddress=" + receiverAddress : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Shipment shipment = (Shipment) o;

        if (id != null ? !id.equals(shipment.id) : shipment.id != null) return false;
        if (shipmentType != null ? !shipmentType.equals(shipment.shipmentType) : shipment.shipmentType != null) return false;
        if (shipmentMode != null ? !shipmentMode.equals(shipment.shipmentMode) : shipment.shipmentMode != null) return false;
        if (pickingType != null ? !pickingType.equals(shipment.pickingType) : shipment.pickingType != null) return false;
        if (status != null ? !status.equals(shipment.status) : shipment.status != null) return false;
        if (substatus != null ? !substatus.equals(shipment.substatus) : shipment.substatus != null) return false;
        if (items != null ? !items.equals(shipment.items) : shipment.items != null) return false;
        if (dateCreated != null ? !dateCreated.equals(shipment.dateCreated) : shipment.dateCreated != null) return false;
        if (lastModified != null ? !lastModified.equals(shipment.lastModified) : shipment.lastModified != null) return false;
        if (dateFirstPrinted != null ? !dateFirstPrinted.equals(shipment.dateFirstPrinted) : shipment.dateFirstPrinted != null) return false;
        if (serviceId != null ? !serviceId.equals(shipment.serviceId) : shipment.serviceId != null) return false;
        if (senderId != null ? !senderId.equals(shipment.senderId) : shipment.senderId != null) return false;
        if (receiverId != null ? !receiverId.equals(shipment.receiverId) : shipment.receiverId != null) return false;
        return receiverAddress != null ? receiverAddress.equals(shipment.receiverAddress) : shipment.receiverAddress == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (shipmentType != null ? shipmentType.hashCode() : 0);
        result = 31 * result + (shipmentMode != null ? shipmentMode.hashCode() : 0);
        result = 31 * result + (pickingType != null ? pickingType.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (substatus != null ? substatus.hashCode() : 0);
        result = 31 * result + (items != null ? items.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (lastModified != null ? lastModified.hashCode() : 0);
        result = 31 * result + (dateFirstPrinted != null ? dateFirstPrinted.hashCode() : 0);
        result = 31 * result + (serviceId != null ? serviceId.hashCode() : 0);
        result = 31 * result + (senderId != null ? senderId.hashCode() : 0);
        result = 31 * result + (receiverId != null ? receiverId.hashCode() : 0);
        result = 31 * result + (receiverAddress != null ? receiverAddress.hashCode() : 0);
        return result;
    }
}

