package ar.com.sdd.mercadopago.entity.payment;

/**
 * Mercado Libre SDK
 * Address class
 * <p>
 * Created by Eduardo Paoletta on 11/9/16.
 */
public class Address {


    private String zipCode = null;
    private String streetName = null;
    private Integer streetNumber = null;
    private String neighborhood = null;
    private String city = null;
    private String federalUnit = null;

    public String getZipCode() {
        return zipCode;
    }

    public Address setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public String getStreetName() {
        return streetName;
    }

    public Address setStreetName(String streetName) {
        this.streetName = streetName;
        return this;
    }

    public Integer getStreetNumber() {
        return streetNumber;
    }

    public Address setStreetNumber(Integer streetNumber) {
        this.streetNumber = streetNumber;
        return this;
    }

    public String getNeighborhood() {
        return neighborhood;
    }

    public Address setNeighborhood(String neighborhood) {
        this.neighborhood = neighborhood;
        return this;
    }

    public String getCity() {
        return city;
    }

    public Address setCity(String city) {
        this.city = city;
        return this;
    }

    public String getFederalUnit() {
        return federalUnit;
    }

    public Address setFederalUnit(String federalUnit) {
        this.federalUnit = federalUnit;
        return this;
    }

    @Override
    public String toString() {
        return "Address ["
                + ((zipCode != null) ? "zipCode=" + zipCode + ", " : "")
                + ((streetName != null) ? "streetName=" + streetName + ", " : "")
                + ((streetNumber != null) ? "streetNumber=" + streetNumber + ", " : "")
                + ((neighborhood != null) ? "neighborhood=" + neighborhood + ", " : "")
                + ((city != null) ? "city=" + city + ", " : "")
                + ((federalUnit != null) ? "federalUnit=" + federalUnit : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Address address = (Address) o;

        if (zipCode != null ? !zipCode.equals(address.zipCode) : address.zipCode != null) return false;
        if (streetName != null ? !streetName.equals(address.streetName) : address.streetName != null) return false;
        if (streetNumber != null ? !streetNumber.equals(address.streetNumber) : address.streetNumber != null) return false;
        if (neighborhood != null ? !neighborhood.equals(address.neighborhood) : address.neighborhood != null) return false;
        if (city != null ? !city.equals(address.city) : address.city != null) return false;
        return federalUnit != null ? federalUnit.equals(address.federalUnit) : address.federalUnit == null;
    }

    @Override
    public int hashCode() {
        int result = zipCode != null ? zipCode.hashCode() : 0;
        result = 31 * result + (streetName != null ? streetName.hashCode() : 0);
        result = 31 * result + (streetNumber != null ? streetNumber.hashCode() : 0);
        result = 31 * result + (neighborhood != null ? neighborhood.hashCode() : 0);
        result = 31 * result + (city != null ? city.hashCode() : 0);
        result = 31 * result + (federalUnit != null ? federalUnit.hashCode() : 0);
        return result;
    }
}
