package ar.com.sdd.mercadopago.entity.payment;

/**
 * Mercado Pago SDK
 * Fee Detail class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
public class FeeDetail {

    public enum Type {
        mercadopago_fee,
        coupon_fee,
        financing_fee,
        shipping_fee,
        application_fee,
        discount_fee
    }

    public enum FeePayer {
        collector,
        payer
    }
    private Type type = null;
    private FeePayer feePayer = null;
    private Float amount = null;


    public Type getType() {
        return type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public FeePayer getFeePayer() {
        return feePayer;
    }

    public void setFeePayer(FeePayer feePayer) {
        this.feePayer = feePayer;
    }

    public Float getAmount() {
        return amount;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    @Override
    public String toString() {
        return "FeeDetail ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((feePayer != null) ? "feePayer=" + feePayer + ", " : "")
                + ((amount != null) ? "amount=" + amount : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        FeeDetail feeDetail = (FeeDetail) o;

        if (type != feeDetail.type) return false;
        if (feePayer != feeDetail.feePayer) return false;
        return amount != null ? amount.equals(feeDetail.amount) : feeDetail.amount == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (feePayer != null ? feePayer.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        return result;
    }
}
