package ar.com.sdd.mercadopago.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Date;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MercadoPagoReportResponse {

    private String id;
    private Date beginDate;
    private Date endDate;
    private Date generationDate;
    private Date lastModified;
    private Date dateCreated;
    private Date dateUploaded;
    private Date downloadDate;
    private String fileName;
    private String createdFrom;
    private String userId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Date getGenerationDate() {
        return generationDate;
    }

    public void setGenerationDate(Date generationDate) {
        this.generationDate = generationDate;
    }

    public Date getLastModified() {
        return lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateUploaded() {
        return dateUploaded;
    }

    public void setDateUploaded(Date dateUploaded) {
        this.dateUploaded = dateUploaded;
    }

    public Date getDownloadDate() {
        return downloadDate;
    }

    public void setDownloadDate(Date downloadDate) {
        this.downloadDate = downloadDate;
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getCreatedFrom() {
        return createdFrom;
    }

    public void setCreatedFrom(String createdFrom) {
        this.createdFrom = createdFrom;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MercadoPagoReportResponse that = (MercadoPagoReportResponse) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (beginDate != null ? !beginDate.equals(that.beginDate) : that.beginDate != null) return false;
        if (endDate != null ? !endDate.equals(that.endDate) : that.endDate != null) return false;
        if (generationDate != null ? !generationDate.equals(that.generationDate) : that.generationDate != null)
            return false;
        if (lastModified != null ? !lastModified.equals(that.lastModified) : that.lastModified != null) return false;
        if (dateCreated != null ? !dateCreated.equals(that.dateCreated) : that.dateCreated != null) return false;
        if (dateUploaded != null ? !dateUploaded.equals(that.dateUploaded) : that.dateUploaded != null) return false;
        if (downloadDate != null ? !downloadDate.equals(that.downloadDate) : that.downloadDate != null) return false;
        if (fileName != null ? !fileName.equals(that.fileName) : that.fileName != null) return false;
        if (createdFrom != null ? !createdFrom.equals(that.createdFrom) : that.createdFrom != null) return false;
        return userId != null ? userId.equals(that.userId) : that.userId == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (beginDate != null ? beginDate.hashCode() : 0);
        result = 31 * result + (endDate != null ? endDate.hashCode() : 0);
        result = 31 * result + (generationDate != null ? generationDate.hashCode() : 0);
        result = 31 * result + (lastModified != null ? lastModified.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (dateUploaded != null ? dateUploaded.hashCode() : 0);
        result = 31 * result + (downloadDate != null ? downloadDate.hashCode() : 0);
        result = 31 * result + (fileName != null ? fileName.hashCode() : 0);
        result = 31 * result + (createdFrom != null ? createdFrom.hashCode() : 0);
        result = 31 * result + (userId != null ? userId.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "SettlementReportResponse ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((beginDate != null) ? "beginDate=" + beginDate + ", " : "")
                + ((endDate != null) ? "endDate=" + endDate + ", " : "")
                + ((generationDate != null) ? "generationDate=" + generationDate + ", " : "")
                + ((lastModified != null) ? "lastModified=" + lastModified + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((dateUploaded != null) ? "dateUploaded=" + dateUploaded + ", " : "")
                + ((downloadDate != null) ? "downloadDate=" + downloadDate + ", " : "")
                + ((fileName != null) ? "fileName=" + fileName + ", " : "")
                + ((createdFrom != null) ? "createdFrom=" + createdFrom + ", " : "")
                + ((userId != null) ? "userId=" + userId : "")
                + "]";
    }
}
