package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.payment.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gson.JsonObject;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

/**
 * Mercado Pago SDK
 * This resource allows you to create, modify or read payments
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Payment {
    public enum OperationType {
        regular_payment,
        money_transfer,
        recurring_payment,
        account_fund,
        payment_addition,
        cellphone_recharge,
        pos_payment
    }

    public enum CurrencyId {
        ARS,
        BRL,
        VEF,
        CLP,
        MXN,
        COP,
        PEN,
        UYU
    }

    public enum Status {
        pending,
        approved,
        authorized,
        in_process,
        in_mediation,
        rejected,
        cancelled,
        refunded,
        charged_back
    }

    public enum PaymentTypeId {
        account_money,
        ticket,
        bank_transfer,
        atm,
        credit_card,
        debit_card,
        prepaid_card
    }

    private String id = null;
    private Date dateCreated = null;
    private Date dateApproved = null;
    private Date dateLastUpdated = null;
    private Date dateOfExpiration = null;
    private Date moneyReleaseDate = null;
    private String moneyReleaseSchema = null;
    private Integer collectorId = null;
    private String authorizationCode = null;
    private OperationType operationType = null;
    private Payer payer = null;
    private Boolean binaryMode = null;
    private Boolean liveMode = null;
    private Order order = null;
    private String externalReference = null;
    private String description = null;
    private JsonObject metadata = null;
    private CurrencyId currencyId = null;
    private BigDecimal transactionAmount = null;
    private BigDecimal transactionAmountRefunded = null;
    private BigDecimal couponAmount = null;
    private Integer campaignId = null;
    private String couponCode = null;
    private TransactionDetails transactionDetails = null;
    private ArrayList<FeeDetail> feeDetails = null;
    private Integer differentialPricingId = null;
    private BigDecimal applicationFee = null;
    private Status status = null;
    private String statusDetail = null;
    private Boolean capture = null;
    private Boolean captured = null;
    private String callForAuthorizeId = null;
    private String paymentMethodId = null;
    private String issuerId = null;
    private PaymentTypeId paymentTypeId = null;
    private String token = null;
    private Card card = null;
    private String statementDescriptor = null;
    private Integer installments = null;
    private String notificationUrl = null;
    private ArrayList<Refund> refunds = null;
    private AdditionalInfo additionalInfo = null;
    private String sponsorId;
    private String processingMode;
    private String merchanAccountId;
    private String aquirer;
    private Long merchantNumber;
    private ArrayList<String> acquirerReconciliation;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getDateApproved() {
        return dateApproved;
    }

    public void setDateApproved(Date dateApproved) {
        this.dateApproved = dateApproved;
    }

    public Date getDateLastUpdated() {
        return dateLastUpdated;
    }

    public void setDateLastUpdated(Date dateLastUpdated) {
        this.dateLastUpdated = dateLastUpdated;
    }

    public Date getMoneyReleaseDate() {
        return moneyReleaseDate;
    }

    public void setMoneyReleaseDate(Date moneyReleaseDate) {
        this.moneyReleaseDate = moneyReleaseDate;
    }

    public Integer getCollectorId() {
        return collectorId;
    }

    public void setCollectorId(Integer collectorId) {
        this.collectorId = collectorId;
    }

    public String getAuthorizationCode() {
        return authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public OperationType getOperationType() {
        return operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public Payer getPayer() {
        return payer;
    }

    public Payment setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public Boolean getBinaryMode() {
        return binaryMode;
    }

    public Payment setBinaryMode(Boolean binaryMode) {
        this.binaryMode = binaryMode;
        return this;
    }

    public Boolean getLiveMode() {
        return liveMode;
    }

    public void setLiveMode(Boolean liveMode) {
        this.liveMode = liveMode;
    }

    public Order getOrder() {
        return order;
    }

    public Payment setOrder(Order order) {
        this.order = order;
        return this;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public Payment setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Payment setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public Payment setMetadata(JsonObject metadata) {
        this.metadata = metadata;
        return this;
    }

    public CurrencyId getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(CurrencyId currencyId) {
        this.currencyId = currencyId;
    }

    public BigDecimal getTransactionAmount() {
        return transactionAmount;
    }

    public Payment setTransactionAmount(BigDecimal transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    public BigDecimal getTransactionAmountRefunded() {
        return transactionAmountRefunded;
    }

    public void setTransactionAmountRefunded(BigDecimal transactionAmountRefunded) {
        this.transactionAmountRefunded = transactionAmountRefunded;
    }

    public BigDecimal getCouponAmount() {
        return couponAmount;
    }

    public Payment setCouponAmount(BigDecimal couponAmount) {
        this.couponAmount = couponAmount;
        return this;
    }

    public TransactionDetails getTransactionDetails() {
        return transactionDetails;
    }

    public void setTransactionDetails(TransactionDetails transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public ArrayList<FeeDetail> getFeeDetails() {
        return feeDetails;
    }

    public void setFeeDetails(ArrayList<FeeDetail> feeDetails) {
        this.feeDetails = feeDetails;
    }

    public Integer getDifferentialPricingId() {
        return differentialPricingId;
    }

    public Payment setDifferentialPricingId(Integer differentialPricingId) {
        this.differentialPricingId = differentialPricingId;
        return this;
    }

    public Status getStatus() {
        return status;
    }

    public Payment setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getStatusDetail() {
        return statusDetail;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public Boolean getCaptured() {
        return captured;
    }

    public void setCaptured(Boolean captured) {
        this.captured = captured;
    }

    public String getCallForAuthorizeId() {
        return callForAuthorizeId;
    }

    public void setCallForAuthorizeId(String callForAuthorizeId) {
        this.callForAuthorizeId = callForAuthorizeId;
    }

    public String getPaymentMethodId() {
        return paymentMethodId;
    }

    public Payment setPaymentMethodId(String paymentMethodId) {
        this.paymentMethodId = paymentMethodId;
        return this;
    }

    public String getIssuerId() {
        return issuerId;
    }

    public Payment setIssuerId(String issuerId) {
        this.issuerId = issuerId;
        return this;
    }

    public PaymentTypeId getPaymentTypeId() {
        return paymentTypeId;
    }

    public void setPaymentTypeId(PaymentTypeId paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
    }

    public Card getCard() {
        return card;
    }

    public void setCard(Card card) {
        this.card = card;
    }

    public String getStatementDescriptor() {
        return statementDescriptor;
    }

    public Payment setStatementDescriptor(String statementDescriptor) {
        this.statementDescriptor = statementDescriptor;
        return this;
    }

    public Integer getInstallments() {
        return installments;
    }

    public Payment setInstallments(Integer installments) {
        this.installments = installments;
        return this;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public Payment setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public ArrayList<Refund> getRefunds() {
        return refunds;
    }

    public void setRefunds(ArrayList<Refund> refunds) {
        this.refunds = refunds;
    }

    public Integer getCampaignId() {
        return campaignId;
    }

    public Payment setCampaignId(Integer campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public String getCouponCode() {
        return couponCode;
    }

    public Payment setCouponCode(String couponCode) {
        this.couponCode = couponCode;
        return this;
    }

    public BigDecimal getApplicationFee() {
        return applicationFee;
    }

    public Payment setApplicationFee(BigDecimal applicationFee) {
        this.applicationFee = applicationFee;
        return this;
    }

    public Boolean getCapture() {
        return capture;
    }

    public Payment setCapture(Boolean capture) {
        this.capture = capture;
        return this;
    }

    public String getToken() {
        return token;
    }

    public Payment setToken(String token) {
        this.token = token;
        return this;
    }

    public AdditionalInfo getAdditionalInfo() {
        return additionalInfo;
    }

    public Payment setAdditionalInfo(AdditionalInfo additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public Date getDateOfExpiration() {
        return dateOfExpiration;
    }

    public void setDateOfExpiration(Date dateOfExpiration) {
        this.dateOfExpiration = dateOfExpiration;
    }

    public String getMoneyReleaseSchema() {
        return moneyReleaseSchema;
    }

    public void setMoneyReleaseSchema(String moneyReleaseSchema) {
        this.moneyReleaseSchema = moneyReleaseSchema;
    }

    public String getSponsorId() {
        return sponsorId;
    }

    public void setSponsorId(String sponsorId) {
        this.sponsorId = sponsorId;
    }

    public String getProcessingMode() {
        return processingMode;
    }

    public void setProcessingMode(String processingMode) {
        this.processingMode = processingMode;
    }

    public String getMerchanAccountId() {
        return merchanAccountId;
    }

    public void setMerchanAccountId(String merchanAccountId) {
        this.merchanAccountId = merchanAccountId;
    }

    public String getAquirer() {
        return aquirer;
    }

    public void setAquirer(String aquirer) {
        this.aquirer = aquirer;
    }

    public Long getMerchantNumber() {
        return merchantNumber;
    }

    public void setMerchantNumber(Long merchantNumber) {
        this.merchantNumber = merchantNumber;
    }

    public ArrayList<String> getAcquirerReconciliation() {
        return acquirerReconciliation;
    }

    public void setAcquirerReconciliation(ArrayList<String> acquirerReconciliation) {
        this.acquirerReconciliation = acquirerReconciliation;
    }

    @Override
    public String toString() {
        return "Payment ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((dateApproved != null) ? "dateApproved=" + dateApproved + ", " : "")
                + ((dateLastUpdated != null) ? "dateLastUpdated=" + dateLastUpdated + ", " : "")
                + ((dateOfExpiration != null) ? "dateOfExpiration=" + dateOfExpiration + ", " : "")
                + ((moneyReleaseDate != null) ? "moneyReleaseDate=" + moneyReleaseDate + ", " : "")
                + ((moneyReleaseSchema != null) ? "moneyReleaseSchema=" + moneyReleaseSchema + ", " : "")
                + ((collectorId != null) ? "collectorId=" + collectorId + ", " : "")
                + ((authorizationCode != null) ? "authorizationCode=" + authorizationCode + ", " : "")
                + ((operationType != null) ? "operationType=" + operationType + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((binaryMode != null) ? "binaryMode=" + binaryMode + ", " : "")
                + ((liveMode != null) ? "liveMode=" + liveMode + ", " : "")
                + ((order != null) ? "order=" + order + ", " : "")
                + ((externalReference != null) ? "externalReference=" + externalReference + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((metadata != null) ? "metadata=" + metadata + ", " : "")
                + ((currencyId != null) ? "currencyId=" + currencyId + ", " : "")
                + ((transactionAmount != null) ? "transactionAmount=" + transactionAmount + ", " : "")
                + ((transactionAmountRefunded != null) ? "transactionAmountRefunded=" + transactionAmountRefunded + ", " : "")
                + ((couponAmount != null) ? "couponAmount=" + couponAmount + ", " : "")
                + ((campaignId != null) ? "campaignId=" + campaignId + ", " : "")
                + ((couponCode != null) ? "couponCode=" + couponCode + ", " : "")
                + ((transactionDetails != null) ? "transactionDetails=" + transactionDetails + ", " : "")
                + ((feeDetails != null) ? "feeDetails=" + Arrays.toString(feeDetails.toArray()) + ", " : "")
                + ((differentialPricingId != null) ? "differentialPricingId=" + differentialPricingId + ", " : "")
                + ((applicationFee != null) ? "applicationFee=" + applicationFee + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((statusDetail != null) ? "statusDetail=" + statusDetail + ", " : "")
                + ((capture != null) ? "capture=" + capture + ", " : "")
                + ((captured != null) ? "captured=" + captured + ", " : "")
                + ((callForAuthorizeId != null) ? "callForAuthorizeId=" + callForAuthorizeId + ", " : "")
                + ((paymentMethodId != null) ? "paymentMethodId=" + paymentMethodId + ", " : "")
                + ((issuerId != null) ? "issuerId=" + issuerId + ", " : "")
                + ((paymentTypeId != null) ? "paymentTypeId=" + paymentTypeId + ", " : "")
                + ((token != null) ? "token=" + token + ", " : "")
                + ((card != null) ? "card=" + card + ", " : "")
                + ((statementDescriptor != null) ? "statementDescriptor=" + statementDescriptor + ", " : "")
                + ((installments != null) ? "installments=" + installments + ", " : "")
                + ((notificationUrl != null) ? "notificationUrl=" + notificationUrl + ", " : "")
                + ((refunds != null) ? "refunds=" + Arrays.toString(refunds.toArray()) + ", " : "")
                + ((additionalInfo != null) ? "additionalInfo=" + additionalInfo + ", " : "")
                + ((sponsorId != null) ? "sponsorId=" + sponsorId + ", " : "")
                + ((processingMode != null) ? "processingMode=" + processingMode + ", " : "")
                + ((merchanAccountId != null) ? "merchanAccountId=" + merchanAccountId + ", " : "")
                + ((aquirer != null) ? "aquirer=" + aquirer + ", " : "")
                + ((merchantNumber != null) ? "merchantNumber=" + merchantNumber + ", " : "")
                + ((acquirerReconciliation != null) ? "acquirerReconciliation=" + Arrays.toString(acquirerReconciliation.toArray()) : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payment payment = (Payment) o;

        if (id != null ? !id.equals(payment.id) : payment.id != null) return false;
        if (dateCreated != null ? !dateCreated.equals(payment.dateCreated) : payment.dateCreated != null) return false;
        if (dateApproved != null ? !dateApproved.equals(payment.dateApproved) : payment.dateApproved != null)
            return false;
        if (dateLastUpdated != null ? !dateLastUpdated.equals(payment.dateLastUpdated) : payment.dateLastUpdated != null)
            return false;
        if (dateOfExpiration != null ? !dateOfExpiration.equals(payment.dateOfExpiration) : payment.dateOfExpiration != null)
            return false;
        if (moneyReleaseDate != null ? !moneyReleaseDate.equals(payment.moneyReleaseDate) : payment.moneyReleaseDate != null)
            return false;
        if (moneyReleaseSchema != null ? !moneyReleaseSchema.equals(payment.moneyReleaseSchema) : payment.moneyReleaseSchema != null)
            return false;
        if (collectorId != null ? !collectorId.equals(payment.collectorId) : payment.collectorId != null) return false;
        if (authorizationCode != null ? !authorizationCode.equals(payment.authorizationCode) : payment.authorizationCode != null)
            return false;
        if (operationType != payment.operationType) return false;
        if (payer != null ? !payer.equals(payment.payer) : payment.payer != null) return false;
        if (binaryMode != null ? !binaryMode.equals(payment.binaryMode) : payment.binaryMode != null) return false;
        if (liveMode != null ? !liveMode.equals(payment.liveMode) : payment.liveMode != null) return false;
        if (order != null ? !order.equals(payment.order) : payment.order != null) return false;
        if (externalReference != null ? !externalReference.equals(payment.externalReference) : payment.externalReference != null)
            return false;
        if (description != null ? !description.equals(payment.description) : payment.description != null) return false;
        if (metadata != null ? !metadata.equals(payment.metadata) : payment.metadata != null) return false;
        if (currencyId != payment.currencyId) return false;
        if (transactionAmount != null ? !transactionAmount.equals(payment.transactionAmount) : payment.transactionAmount != null)
            return false;
        if (transactionAmountRefunded != null ? !transactionAmountRefunded.equals(payment.transactionAmountRefunded) : payment.transactionAmountRefunded != null)
            return false;
        if (couponAmount != null ? !couponAmount.equals(payment.couponAmount) : payment.couponAmount != null)
            return false;
        if (campaignId != null ? !campaignId.equals(payment.campaignId) : payment.campaignId != null) return false;
        if (couponCode != null ? !couponCode.equals(payment.couponCode) : payment.couponCode != null) return false;
        if (transactionDetails != null ? !transactionDetails.equals(payment.transactionDetails) : payment.transactionDetails != null)
            return false;
        if (feeDetails != null ? !feeDetails.equals(payment.feeDetails) : payment.feeDetails != null) return false;
        if (differentialPricingId != null ? !differentialPricingId.equals(payment.differentialPricingId) : payment.differentialPricingId != null)
            return false;
        if (applicationFee != null ? !applicationFee.equals(payment.applicationFee) : payment.applicationFee != null)
            return false;
        if (status != payment.status) return false;
        if (statusDetail != null ? !statusDetail.equals(payment.statusDetail) : payment.statusDetail != null)
            return false;
        if (capture != null ? !capture.equals(payment.capture) : payment.capture != null) return false;
        if (captured != null ? !captured.equals(payment.captured) : payment.captured != null) return false;
        if (callForAuthorizeId != null ? !callForAuthorizeId.equals(payment.callForAuthorizeId) : payment.callForAuthorizeId != null)
            return false;
        if (paymentMethodId != null ? !paymentMethodId.equals(payment.paymentMethodId) : payment.paymentMethodId != null)
            return false;
        if (issuerId != null ? !issuerId.equals(payment.issuerId) : payment.issuerId != null) return false;
        if (paymentTypeId != payment.paymentTypeId) return false;
        if (token != null ? !token.equals(payment.token) : payment.token != null) return false;
        if (card != null ? !card.equals(payment.card) : payment.card != null) return false;
        if (statementDescriptor != null ? !statementDescriptor.equals(payment.statementDescriptor) : payment.statementDescriptor != null)
            return false;
        if (installments != null ? !installments.equals(payment.installments) : payment.installments != null)
            return false;
        if (notificationUrl != null ? !notificationUrl.equals(payment.notificationUrl) : payment.notificationUrl != null)
            return false;
        if (refunds != null ? !refunds.equals(payment.refunds) : payment.refunds != null) return false;
        if (additionalInfo != null ? !additionalInfo.equals(payment.additionalInfo) : payment.additionalInfo != null)
            return false;
        if (sponsorId != null ? !sponsorId.equals(payment.sponsorId) : payment.sponsorId != null) return false;
        if (processingMode != null ? !processingMode.equals(payment.processingMode) : payment.processingMode != null)
            return false;
        if (merchanAccountId != null ? !merchanAccountId.equals(payment.merchanAccountId) : payment.merchanAccountId != null)
            return false;
        if (aquirer != null ? !aquirer.equals(payment.aquirer) : payment.aquirer != null) return false;
        if (merchantNumber != null ? !merchantNumber.equals(payment.merchantNumber) : payment.merchantNumber != null)
            return false;
        return acquirerReconciliation != null ? acquirerReconciliation.equals(payment.acquirerReconciliation) : payment.acquirerReconciliation == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (dateApproved != null ? dateApproved.hashCode() : 0);
        result = 31 * result + (dateLastUpdated != null ? dateLastUpdated.hashCode() : 0);
        result = 31 * result + (dateOfExpiration != null ? dateOfExpiration.hashCode() : 0);
        result = 31 * result + (moneyReleaseDate != null ? moneyReleaseDate.hashCode() : 0);
        result = 31 * result + (moneyReleaseSchema != null ? moneyReleaseSchema.hashCode() : 0);
        result = 31 * result + (collectorId != null ? collectorId.hashCode() : 0);
        result = 31 * result + (authorizationCode != null ? authorizationCode.hashCode() : 0);
        result = 31 * result + (operationType != null ? operationType.hashCode() : 0);
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (binaryMode != null ? binaryMode.hashCode() : 0);
        result = 31 * result + (liveMode != null ? liveMode.hashCode() : 0);
        result = 31 * result + (order != null ? order.hashCode() : 0);
        result = 31 * result + (externalReference != null ? externalReference.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (metadata != null ? metadata.hashCode() : 0);
        result = 31 * result + (currencyId != null ? currencyId.hashCode() : 0);
        result = 31 * result + (transactionAmount != null ? transactionAmount.hashCode() : 0);
        result = 31 * result + (transactionAmountRefunded != null ? transactionAmountRefunded.hashCode() : 0);
        result = 31 * result + (couponAmount != null ? couponAmount.hashCode() : 0);
        result = 31 * result + (campaignId != null ? campaignId.hashCode() : 0);
        result = 31 * result + (couponCode != null ? couponCode.hashCode() : 0);
        result = 31 * result + (transactionDetails != null ? transactionDetails.hashCode() : 0);
        result = 31 * result + (feeDetails != null ? feeDetails.hashCode() : 0);
        result = 31 * result + (differentialPricingId != null ? differentialPricingId.hashCode() : 0);
        result = 31 * result + (applicationFee != null ? applicationFee.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (statusDetail != null ? statusDetail.hashCode() : 0);
        result = 31 * result + (capture != null ? capture.hashCode() : 0);
        result = 31 * result + (captured != null ? captured.hashCode() : 0);
        result = 31 * result + (callForAuthorizeId != null ? callForAuthorizeId.hashCode() : 0);
        result = 31 * result + (paymentMethodId != null ? paymentMethodId.hashCode() : 0);
        result = 31 * result + (issuerId != null ? issuerId.hashCode() : 0);
        result = 31 * result + (paymentTypeId != null ? paymentTypeId.hashCode() : 0);
        result = 31 * result + (token != null ? token.hashCode() : 0);
        result = 31 * result + (card != null ? card.hashCode() : 0);
        result = 31 * result + (statementDescriptor != null ? statementDescriptor.hashCode() : 0);
        result = 31 * result + (installments != null ? installments.hashCode() : 0);
        result = 31 * result + (notificationUrl != null ? notificationUrl.hashCode() : 0);
        result = 31 * result + (refunds != null ? refunds.hashCode() : 0);
        result = 31 * result + (additionalInfo != null ? additionalInfo.hashCode() : 0);
        result = 31 * result + (sponsorId != null ? sponsorId.hashCode() : 0);
        result = 31 * result + (processingMode != null ? processingMode.hashCode() : 0);
        result = 31 * result + (merchanAccountId != null ? merchanAccountId.hashCode() : 0);
        result = 31 * result + (aquirer != null ? aquirer.hashCode() : 0);
        result = 31 * result + (merchantNumber != null ? merchantNumber.hashCode() : 0);
        result = 31 * result + (acquirerReconciliation != null ? acquirerReconciliation.hashCode() : 0);
        return result;
    }
}
