package ar.com.sdd.mercadopago.entity.merchantorder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.math.BigDecimal;

/**
 * Mercado Pago MercadoPago
 * Merchant Order Item class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Item {

    private String id = null;
    private String categoryId = null;
    private String currencyId = null;
    private String description = null;
    private String pictureUrl = null;
    private Integer quantity = null;
    private BigDecimal unitPrice = null;
    private String title = null;


    public String getId() {
        return id;
    }

    public Item setId(String id) {
        this.id = id;
        return this;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public Item setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public String getCurrencyId() {
        return currencyId;
    }

    public Item setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Item setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPictureUrl() {
        return pictureUrl;
    }

    public Item setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
        return this;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public Item setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public Item setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Item setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public String toString() {
        return "Item ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((categoryId != null) ? "categoryId=" + categoryId + ", " : "")
                + ((currencyId != null) ? "currencyId=" + currencyId + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((pictureUrl != null) ? "pictureUrl=" + pictureUrl + ", " : "")
                + ((quantity != null) ? "quantity=" + quantity + ", " : "")
                + ((unitPrice != null) ? "unitPrice=" + unitPrice + ", " : "")
                + ((title != null) ? "title=" + title : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Item item = (Item) o;

        if (id != null ? !id.equals(item.id) : item.id != null) return false;
        if (categoryId != null ? !categoryId.equals(item.categoryId) : item.categoryId != null) return false;
        if (currencyId != null ? !currencyId.equals(item.currencyId) : item.currencyId != null) return false;
        if (description != null ? !description.equals(item.description) : item.description != null) return false;
        if (pictureUrl != null ? !pictureUrl.equals(item.pictureUrl) : item.pictureUrl != null) return false;
        if (quantity != null ? !quantity.equals(item.quantity) : item.quantity != null) return false;
        if (unitPrice != null ? !unitPrice.equals(item.unitPrice) : item.unitPrice != null) return false;
        return title != null ? title.equals(item.title) : item.title == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (categoryId != null ? categoryId.hashCode() : 0);
        result = 31 * result + (currencyId != null ? currencyId.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (pictureUrl != null ? pictureUrl.hashCode() : 0);
        result = 31 * result + (quantity != null ? quantity.hashCode() : 0);
        result = 31 * result + (unitPrice != null ? unitPrice.hashCode() : 0);
        result = 31 * result + (title != null ? title.hashCode() : 0);
        return result;
    }
}
