package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Payer Payment class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Payer {

    public enum type {
        customer,
        registered,
        guest,
        anonymous
    }
    private type type = null;
    private String id = null;
    private String email = null;
    private Identification identification = null;
    private PayerPhone phone = null;
    private String firstName = null;
    private String lastName = null;
    private Address address = null;

    public Payer.type getType() {
        return type;
    }

    public Payer setType(Payer.type type) {
        this.type = type;
        return this;
    }

    public String getId() {
        return id;
    }

    public Payer setId(String id) {
        this.id = id;
        return this;
    }

    public String getEmail() {
        return email;
    }

    public Payer setEmail(String email) {
        this.email = email;
        return this;
    }

    public Identification getIdentification() {
        return identification;
    }

    public Payer setIdentification(Identification identification) {
        this.identification = identification;
        return this;
    }

    public PayerPhone getPhone() {
        return phone;
    }

    public Payer setPhone(PayerPhone phone) {
        this.phone = phone;
        return this;
    }

    public String getFirstName() {
        return firstName;
    }

    public Payer setFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public String getLastName() {
        return lastName;
    }

    public Payer setLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public Address getAddress() {
        return address;
    }

    public Payer setAddress(Address address) {
        this.address = address;
        return this;
    }

    @Override
    public String toString() {
        return "Payer ["
                + ((type != null) ? "type=" + type + ", " : "")
                + ((id != null) ? "id=" + id + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((identification != null) ? "identification=" + identification + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((firstName != null) ? "firstName=" + firstName + ", " : "")
                + ((lastName != null) ? "lastName=" + lastName + ", " : "")
                + ((address != null) ? "address=" + address : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payer payer = (Payer) o;

        if (type != payer.type) return false;
        if (id != null ? !id.equals(payer.id) : payer.id != null) return false;
        if (email != null ? !email.equals(payer.email) : payer.email != null) return false;
        if (identification != null ? !identification.equals(payer.identification) : payer.identification != null) return false;
        if (phone != null ? !phone.equals(payer.phone) : payer.phone != null) return false;
        if (firstName != null ? !firstName.equals(payer.firstName) : payer.firstName != null) return false;
        if (lastName != null ? !lastName.equals(payer.lastName) : payer.lastName != null) return false;
        return address != null ? address.equals(payer.address) : payer.address == null;
    }

    @Override
    public int hashCode() {
        int result = type != null ? type.hashCode() : 0;
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (identification != null ? identification.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (firstName != null ? firstName.hashCode() : 0);
        result = 31 * result + (lastName != null ? lastName.hashCode() : 0);
        result = 31 * result + (address != null ? address.hashCode() : 0);
        return result;
    }
}
