/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.mercadopago.entity.MPError;
import ar.com.sdd.mercadopago.entity.MPErrorResponse;
import ar.com.sdd.mercadopago.entity.MPPaging;
import ar.com.sdd.mercadopago.entity.MPTokenOAuth2;
import ar.com.sdd.mercadopago.entity.Payment;
import ar.com.sdd.mercadopago.entity.Preference;
import ar.com.sdd.mercadopago.entity.account.MercadoPagoReportResponse;
import ar.com.sdd.mercadopago.entity.account.MercadoPagotReportRequest;
import ar.com.sdd.mercadopago.entity.user.User;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MercadoPagoConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(MercadoPagoConnector.class);
    private static final String MP_BASE_URL = "https://api.mercadopago.com";

    public Preference savePreference(String token, Preference request) throws RestConnectorException {
        log.debug((Object)("[savePreference] Request POST preferencia [" + request + "]"));
        Preference response = (Preference)this.getNewRestConnector().genericPost((Object)request, Preference.class, MPError.class, "/checkout/preferences?access_token=" + token);
        log.debug((Object)("[savePreference] Response POST de la preferencia [" + response + "]"));
        return response;
    }

    public MPPaging<Payment> searchPayment(String token, String externalReference) throws RestConnectorException {
        log.debug((Object)("[searchPayment] Request con externalReference [" + externalReference + "]"));
        MPPaging response = (MPPaging)this.getNewRestConnector().genericGet(null, MPPaging.MPPagingPayment.class, MPError.class, "/v1/payments/search?external_reference=" + externalReference + "&access_token=" + token);
        log.debug((Object)("[searchPayment] Response con externalReference [" + externalReference + "],  [" + response + "]"));
        return response;
    }

    public TokenOAuth2 getToken(String clientId, String clientSecret) throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "client_credentials");
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + clientId + "], clientSecret [" + clientSecret + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        RestConnector connector = new RestConnector(environment, null);
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/oauth/token", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }

    public MPTokenOAuth2 getAuthorizationCodeToken(String clientId, String clientSecret, String mercadoPagoId, String redirectUri, String refreshToken) throws RestConnectorException {
        Form form = new Form();
        if (StringUtils.isNotEmpty((CharSequence)clientId)) {
            form.param("client_id", clientId);
        }
        form.param("client_secret", clientSecret);
        form.param("code", mercadoPagoId);
        form.param("redirect_uri", redirectUri);
        form.param("grant_type", "authorization_code");
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            form.param("refresh_token", refreshToken);
            form.param("grant_type", "authorization_code");
        }
        log.debug((Object)("[getAuthorizationCodeToken] Por recuperar token con clientId [" + clientId + "], clientSecret [" + clientSecret + "], mercadoPagoId [" + mercadoPagoId + "], redirectUri [" + redirectUri + "], refreshToken [" + refreshToken + "]"));
        MPTokenOAuth2 tokenOAuth2Response = (MPTokenOAuth2)this.getNewRestConnectorNoSecurityManager().genericPost((Object)form, MPTokenOAuth2.class, MPErrorResponse.class, "/oauth/token", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getAuthorizationCodeToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }

    public User getUsersMe(String userAccessToken) throws RestConnectorException {
        log.debug((Object)("[getUsersMe] Por recuperar usuario con userAccessToken [" + userAccessToken + "]"));
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/users/me").add("access_token", userAccessToken);
        User user = (User)this.getNewRestConnectorNoSecurityManager().genericGet(Void.class, User.class, MPErrorResponse.class, queryBuilder.build());
        log.debug((Object)("[getUsersMe] User recuperado [" + user + "]"));
        return user;
    }

    public Payment postPayments(Payment payment, String mpTokenOAuthAccessToken) throws RestConnectorException {
        log.debug((Object)("[postPayments] Por enviar el pago [" + payment + "] para el accessToken OAuth2 [" + mpTokenOAuthAccessToken + "]"));
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/v1/payments").add("access_token", mpTokenOAuthAccessToken);
        Payment paymentResponse = (Payment)this.getNewRestConnectorNoSecurityManager().genericPost((Object)payment, Payment.class, MPErrorResponse.class, queryBuilder.build());
        log.debug((Object)("[postPayments] Payment devuelto [" + paymentResponse + "]"));
        return paymentResponse;
    }

    public MercadoPagoReportResponse postMercadoPagoReport(String token, MercadoPagotReportRequest request, String reportType) throws RestConnectorException {
        log.debug((Object)"[postMercadoPagoReport] Request POST mercadoPago");
        MercadoPagoReportResponse response = (MercadoPagoReportResponse)this.getNewRestConnector().genericPost((Object)request, MercadoPagoReportResponse.class, "/v1/account/" + reportType + "?access_token=" + token);
        log.debug((Object)("[postMercadoPagoReport] Response [" + response + "]"));
        return response;
    }

    public List<MercadoPagoReportResponse> getMercadoPagoReports(String token, String reportType) throws RestConnectorException {
        log.debug((Object)"[getMercadoPagoReports] Request GET getMercadoPagoReports");
        MercadoPagoReportResponse[] responseArray = (MercadoPagoReportResponse[])this.getNewRestConnector().genericGet(null, MercadoPagoReportResponse[].class, "/v1/account/" + reportType + "/list?access_token=" + token);
        List<MercadoPagoReportResponse> response = Arrays.asList(responseArray);
        log.debug((Object)("[getMercadoPagoReports] Request GET getMercadoPagoReports response [" + response + "]"));
        return response;
    }

    public String downloadMercadoPagoReport(String fileName, String token, String reportType) throws RestConnectorException {
        log.debug((Object)("[downloadMercadoPagoReport] Request GET bank_report fileName [" + fileName + "]"));
        String response = (String)this.getNewRestConnector().genericGet(null, String.class, "/v1/account/" + reportType + "/" + fileName + "?access_token=" + token);
        log.debug((Object)("[downloadMercadoPagoReport] Response con   fileName [" + fileName + "][" + response + "]"));
        return response;
    }

    private RestConnector getNewRestConnector() {
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        return new RestConnector(environment, (RestSecurityManager)this);
    }

    private RestConnector getNewRestConnectorNoSecurityManager() {
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        return new RestConnector(environment, null);
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }
}

