/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.entity.preference;

import ar.com.sdd.mercadopago.entity.preference.AddressReceiver;
import ar.com.sdd.mercadopago.entity.preference.ShippingMethod;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Shipments {
    private ShipmentMode mode = null;
    private Boolean localPickup = null;
    private String dimensions = null;
    private Integer defaultShippingMethod = null;
    private ArrayList<ShippingMethod> freeMethods = null;
    private BigDecimal cost = null;
    private Boolean freeShipping = null;
    private AddressReceiver receiverAddress = null;

    public AddressReceiver getReceiverAddress() {
        return this.receiverAddress;
    }

    public Shipments setReceiverAddress(AddressReceiver addressReceiver) {
        this.receiverAddress = addressReceiver;
        return this;
    }

    public ShipmentMode getMode() {
        return this.mode;
    }

    public Shipments setMode(ShipmentMode mode) {
        this.mode = mode;
        return this;
    }

    public Boolean getLocalPickup() {
        return this.localPickup;
    }

    public Shipments setLocalPickup(Boolean localPickup) {
        this.localPickup = localPickup;
        return this;
    }

    public String getDimensions() {
        return this.dimensions;
    }

    public Shipments setDimensions(String dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    public Integer getDefaultShippingMethod() {
        return this.defaultShippingMethod;
    }

    public Shipments setDefaultShippingMethod(Integer defaultShippingMethod) {
        this.defaultShippingMethod = defaultShippingMethod;
        return this;
    }

    public ArrayList<ShippingMethod> getFreeMethods() {
        return this.freeMethods;
    }

    public Shipments setFreeMethods(ArrayList<ShippingMethod> freeMethods) {
        this.freeMethods = freeMethods;
        return this;
    }

    public ArrayList<ShippingMethod> appendFreeMethods(ShippingMethod freeMethod) {
        if (this.freeMethods == null) {
            this.freeMethods = new ArrayList();
        }
        this.freeMethods.add(freeMethod);
        return this.getFreeMethods();
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public Shipments setCost(BigDecimal cost) {
        this.cost = cost;
        return this;
    }

    public Boolean getFreeShipping() {
        return this.freeShipping;
    }

    public Shipments setFreeShipping(Boolean freeShipping) {
        this.freeShipping = freeShipping;
        return this;
    }

    public String toString() {
        return "Shipments [" + (String)(this.mode != null ? "mode=" + this.mode + ", " : "") + (String)(this.localPickup != null ? "localPickup=" + this.localPickup + ", " : "") + (String)(this.dimensions != null ? "dimensions=" + this.dimensions + ", " : "") + (String)(this.defaultShippingMethod != null ? "defaultShippingMethod=" + this.defaultShippingMethod + ", " : "") + (String)(this.freeMethods != null ? "freeMethods=" + Arrays.toString(this.freeMethods.toArray()) + ", " : "") + (String)(this.cost != null ? "cost=" + this.cost + ", " : "") + (String)(this.freeShipping != null ? "freeShipping=" + this.freeShipping + ", " : "") + (String)(this.receiverAddress != null ? "receiverAddress=" + this.receiverAddress : "") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipments shipments = (Shipments)o;
        if (this.mode != shipments.mode) {
            return false;
        }
        if (this.localPickup != null ? !this.localPickup.equals(shipments.localPickup) : shipments.localPickup != null) {
            return false;
        }
        if (this.dimensions != null ? !this.dimensions.equals(shipments.dimensions) : shipments.dimensions != null) {
            return false;
        }
        if (this.defaultShippingMethod != null ? !this.defaultShippingMethod.equals(shipments.defaultShippingMethod) : shipments.defaultShippingMethod != null) {
            return false;
        }
        if (this.freeMethods != null ? !this.freeMethods.equals(shipments.freeMethods) : shipments.freeMethods != null) {
            return false;
        }
        if (this.cost != null ? !this.cost.equals(shipments.cost) : shipments.cost != null) {
            return false;
        }
        if (this.freeShipping != null ? !this.freeShipping.equals(shipments.freeShipping) : shipments.freeShipping != null) {
            return false;
        }
        return this.receiverAddress != null ? this.receiverAddress.equals(shipments.receiverAddress) : shipments.receiverAddress == null;
    }

    public int hashCode() {
        int result = this.mode != null ? this.mode.hashCode() : 0;
        result = 31 * result + (this.localPickup != null ? this.localPickup.hashCode() : 0);
        result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
        result = 31 * result + (this.defaultShippingMethod != null ? this.defaultShippingMethod.hashCode() : 0);
        result = 31 * result + (this.freeMethods != null ? this.freeMethods.hashCode() : 0);
        result = 31 * result + (this.cost != null ? this.cost.hashCode() : 0);
        result = 31 * result + (this.freeShipping != null ? this.freeShipping.hashCode() : 0);
        result = 31 * result + (this.receiverAddress != null ? this.receiverAddress.hashCode() : 0);
        return result;
    }

    public static enum ShipmentMode {
        custom,
        me2,
        not_specified;

    }
}

