package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Libre SDk
 * Shipment class
 *
 * Created by Eduardo Paoletta on 11/9/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Shipments {

    private AddressReceiver receiverAddress = null;


    public AddressReceiver getReceiverAddress() {
        return receiverAddress;
    }

    public Shipments setReceiverAddress(AddressReceiver addressReceiver) {
        this.receiverAddress = addressReceiver;
        return this;
    }

    @Override
    public String toString() {
        return "Shipments ["
                + ((receiverAddress != null) ? "receiverAddress=" + receiverAddress : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Shipments shipments = (Shipments) o;

        return receiverAddress != null ? receiverAddress.equals(shipments.receiverAddress) : shipments.receiverAddress == null;
    }

    @Override
    public int hashCode() {
        return receiverAddress != null ? receiverAddress.hashCode() : 0;
    }
}
