
package ar.com.sdd.mercadopago.entity.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class BuyerReputation {

    @JsonProperty("canceled_transactions")
    private Long canceledTransactions;
    @JsonProperty("tags")
    private List<Object> tags = null;
    @JsonProperty("transactions")
    private Transactions transactions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("canceled_transactions")
    public Long getCanceledTransactions() {
        return canceledTransactions;
    }

    @JsonProperty("canceled_transactions")
    public void setCanceledTransactions(Long canceledTransactions) {
        this.canceledTransactions = canceledTransactions;
    }

    @JsonProperty("tags")
    public List<Object> getTags() {
        return tags;
    }

    @JsonProperty("tags")
    public void setTags(List<Object> tags) {
        this.tags = tags;
    }

    @JsonProperty("transactions")
    public Transactions getTransactions() {
        return transactions;
    }

    @JsonProperty("transactions")
    public void setTransactions(Transactions transactions) {
        this.transactions = transactions;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "BuyerReputation ["
                + ((canceledTransactions != null) ? "canceledTransactions=" + canceledTransactions + ", " : "")
                + ((tags != null) ? "tags=" + Arrays.toString(tags.toArray()) + ", " : "")
                + ((transactions != null) ? "transactions=" + transactions + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
