
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Status {

    @JsonProperty("billing")
    private Billing billing;
    @JsonProperty("buy")
    private Buy buy;
    @JsonProperty("confirmed_email")
    private Boolean confirmedEmail;
    @JsonProperty("shopping_cart")
    private ShoppingCart shoppingCart;
    @JsonProperty("immediate_payment")
    private Boolean immediatePayment;
    @JsonProperty("list")
    private List list;
    @JsonProperty("mercadoenvios")
    private String mercadoenvios;
    @JsonProperty("mercadopago_account_type")
    private String mercadopagoAccountType;
    @JsonProperty("mercadopago_tc_accepted")
    private Boolean mercadopagoTcAccepted;
    @JsonProperty("required_action")
    private String requiredAction;
    @JsonProperty("sell")
    private Sell sell;
    @JsonProperty("site_status")
    private String siteStatus;
    @JsonProperty("user_type")
    private String userType;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("billing")
    public Billing getBilling() {
        return billing;
    }

    @JsonProperty("billing")
    public void setBilling(Billing billing) {
        this.billing = billing;
    }

    @JsonProperty("buy")
    public Buy getBuy() {
        return buy;
    }

    @JsonProperty("buy")
    public void setBuy(Buy buy) {
        this.buy = buy;
    }

    @JsonProperty("confirmed_email")
    public Boolean getConfirmedEmail() {
        return confirmedEmail;
    }

    @JsonProperty("confirmed_email")
    public void setConfirmedEmail(Boolean confirmedEmail) {
        this.confirmedEmail = confirmedEmail;
    }

    @JsonProperty("shopping_cart")
    public ShoppingCart getShoppingCart() {
        return shoppingCart;
    }

    @JsonProperty("shopping_cart")
    public void setShoppingCart(ShoppingCart shoppingCart) {
        this.shoppingCart = shoppingCart;
    }

    @JsonProperty("immediate_payment")
    public Boolean getImmediatePayment() {
        return immediatePayment;
    }

    @JsonProperty("immediate_payment")
    public void setImmediatePayment(Boolean immediatePayment) {
        this.immediatePayment = immediatePayment;
    }

    @JsonProperty("list")
    public List getList() {
        return list;
    }

    @JsonProperty("list")
    public void setList(List list) {
        this.list = list;
    }

    @JsonProperty("mercadoenvios")
    public String getMercadoenvios() {
        return mercadoenvios;
    }

    @JsonProperty("mercadoenvios")
    public void setMercadoenvios(String mercadoenvios) {
        this.mercadoenvios = mercadoenvios;
    }

    @JsonProperty("mercadopago_account_type")
    public String getMercadopagoAccountType() {
        return mercadopagoAccountType;
    }

    @JsonProperty("mercadopago_account_type")
    public void setMercadopagoAccountType(String mercadopagoAccountType) {
        this.mercadopagoAccountType = mercadopagoAccountType;
    }

    @JsonProperty("mercadopago_tc_accepted")
    public Boolean getMercadopagoTcAccepted() {
        return mercadopagoTcAccepted;
    }

    @JsonProperty("mercadopago_tc_accepted")
    public void setMercadopagoTcAccepted(Boolean mercadopagoTcAccepted) {
        this.mercadopagoTcAccepted = mercadopagoTcAccepted;
    }

    @JsonProperty("required_action")
    public String getRequiredAction() {
        return requiredAction;
    }

    @JsonProperty("required_action")
    public void setRequiredAction(String requiredAction) {
        this.requiredAction = requiredAction;
    }

    @JsonProperty("sell")
    public Sell getSell() {
        return sell;
    }

    @JsonProperty("sell")
    public void setSell(Sell sell) {
        this.sell = sell;
    }

    @JsonProperty("site_status")
    public String getSiteStatus() {
        return siteStatus;
    }

    @JsonProperty("site_status")
    public void setSiteStatus(String siteStatus) {
        this.siteStatus = siteStatus;
    }

    @JsonProperty("user_type")
    public String getUserType() {
        return userType;
    }

    @JsonProperty("user_type")
    public void setUserType(String userType) {
        this.userType = userType;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }


    @Override
    public String toString() {
        return "Status ["
                + ((billing != null) ? "billing=" + billing + ", " : "")
                + ((buy != null) ? "buy=" + buy + ", " : "")
                + ((confirmedEmail != null) ? "confirmedEmail=" + confirmedEmail + ", " : "")
                + ((shoppingCart != null) ? "shoppingCart=" + shoppingCart + ", " : "")
                + ((immediatePayment != null) ? "immediatePayment=" + immediatePayment + ", " : "")
                + ((list != null) ? "list=" + list + ", " : "")
                + ((mercadoenvios != null) ? "mercadoenvios=" + mercadoenvios + ", " : "")
                + ((mercadopagoAccountType != null) ? "mercadopagoAccountType=" + mercadopagoAccountType + ", " : "")
                + ((mercadopagoTcAccepted != null) ? "mercadopagoTcAccepted=" + mercadopagoTcAccepted + ", " : "")
                + ((requiredAction != null) ? "requiredAction=" + requiredAction + ", " : "")
                + ((sell != null) ? "sell=" + sell + ", " : "")
                + ((siteStatus != null) ? "siteStatus=" + siteStatus + ", " : "")
                + ((userType != null) ? "userType=" + userType + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
