package ar.com.sdd.mercadopago.entity.merchantorder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Date;

/**
 * Mercado Pago SDK
 * Merchant Order Payment class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MerchantOrderPayment {

    public enum CurrencyId {
        ARS,
        BRL,
        VEF,
        CLP,
        MXN,
        COP,
        UYU
    }
    public enum OperationType {
        regular_payment,
        payment_addition
    }
    private String id = null;
    private Float transactionAmount = null;
    private Float totalPaidAmount = null;
    private Float shippingCost = null;
    private CurrencyId currencyId = null;
    private String status = null;
    private String statusDetail = null;
    private OperationType operationType = null;
    private Date dateApproved = null;
    private Date dateCreated = null;
    private Date lastModified = null;
    private Float amountRefunded = null;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Float getTransactionAmount() {
        return transactionAmount;
    }

    public void setTransactionAmount(Float transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public Float getTotalPaidAmount() {
        return totalPaidAmount;
    }

    public void setTotalPaidAmount(Float totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    public Float getShippingCost() {
        return shippingCost;
    }

    public void setShippingCost(Float shippingCost) {
        this.shippingCost = shippingCost;
    }

    public CurrencyId getCurrencyId() {
        return currencyId;
    }

    public void setCurrencyId(CurrencyId currencyId) {
        this.currencyId = currencyId;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatusDetail() {
        return statusDetail;
    }

    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

    public OperationType getOperationType() {
        return operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public Date getDateApproved() {
        return dateApproved;
    }

    public void setDateApproved(Date dateApproved) {
        this.dateApproved = dateApproved;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public Date getLastModified() {
        return lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Float getAmountRefunded() {
        return amountRefunded;
    }

    public void setAmountRefunded(Float amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    @Override
    public String toString() {
        return "MerchantOrderPayment ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((transactionAmount != null) ? "transactionAmount=" + transactionAmount + ", " : "")
                + ((totalPaidAmount != null) ? "totalPaidAmount=" + totalPaidAmount + ", " : "")
                + ((shippingCost != null) ? "shippingCost=" + shippingCost + ", " : "")
                + ((currencyId != null) ? "currencyId=" + currencyId + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((statusDetail != null) ? "statusDetail=" + statusDetail + ", " : "")
                + ((operationType != null) ? "operationType=" + operationType + ", " : "")
                + ((dateApproved != null) ? "dateApproved=" + dateApproved + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((lastModified != null) ? "lastModified=" + lastModified + ", " : "")
                + ((amountRefunded != null) ? "amountRefunded=" + amountRefunded : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MerchantOrderPayment that = (MerchantOrderPayment) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (transactionAmount != null ? !transactionAmount.equals(that.transactionAmount) : that.transactionAmount != null) return false;
        if (totalPaidAmount != null ? !totalPaidAmount.equals(that.totalPaidAmount) : that.totalPaidAmount != null) return false;
        if (shippingCost != null ? !shippingCost.equals(that.shippingCost) : that.shippingCost != null) return false;
        if (currencyId != that.currencyId) return false;
        if (status != null ? !status.equals(that.status) : that.status != null) return false;
        if (statusDetail != null ? !statusDetail.equals(that.statusDetail) : that.statusDetail != null) return false;
        if (operationType != that.operationType) return false;
        if (dateApproved != null ? !dateApproved.equals(that.dateApproved) : that.dateApproved != null) return false;
        if (dateCreated != null ? !dateCreated.equals(that.dateCreated) : that.dateCreated != null) return false;
        if (lastModified != null ? !lastModified.equals(that.lastModified) : that.lastModified != null) return false;
        return amountRefunded != null ? amountRefunded.equals(that.amountRefunded) : that.amountRefunded == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (transactionAmount != null ? transactionAmount.hashCode() : 0);
        result = 31 * result + (totalPaidAmount != null ? totalPaidAmount.hashCode() : 0);
        result = 31 * result + (shippingCost != null ? shippingCost.hashCode() : 0);
        result = 31 * result + (currencyId != null ? currencyId.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (statusDetail != null ? statusDetail.hashCode() : 0);
        result = 31 * result + (operationType != null ? operationType.hashCode() : 0);
        result = 31 * result + (dateApproved != null ? dateApproved.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (lastModified != null ? lastModified.hashCode() : 0);
        result = 31 * result + (amountRefunded != null ? amountRefunded.hashCode() : 0);
        return result;
    }
}
