package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.gson.JsonObject;

import java.util.Date;

/**
 * Mercado Pago SDK
 * Refund class
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Refund {

    private Number id = null;
    private Number paymentId = null;
    private Float amount = null;
    private JsonObject metadata = null;
    private Source source = null;
    private Date dateCreated = null;
    private String uniqueSequenceNumber = null;


    public Number getId() {
        return id;
    }

    public Number getPaymentId() {
        return paymentId;
    }

    public Float getAmount() {
        return amount;
    }

    public JsonObject getMetadata() {
        return metadata;
    }

    public Source getSource() {
        return source;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public String getUniqueSequenceNumber() {
        return uniqueSequenceNumber;
    }

    public void setId(Number id) {
        this.id = id;
    }

    public void setPaymentId(Number paymentId) {
        this.paymentId = paymentId;
    }

    public void setAmount(Float amount) {
        this.amount = amount;
    }

    public void setMetadata(JsonObject metadata) {
        this.metadata = metadata;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public void setUniqueSequenceNumber(String uniqueSequenceNumber) {
        this.uniqueSequenceNumber = uniqueSequenceNumber;
    }

    @Override
    public String toString() {
        return "Refund ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((paymentId != null) ? "paymentId=" + paymentId + ", " : "")
                + ((amount != null) ? "amount=" + amount + ", " : "")
                + ((metadata != null) ? "metadata=" + metadata + ", " : "")
                + ((source != null) ? "source=" + source + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((uniqueSequenceNumber != null) ? "uniqueSequenceNumber=" + uniqueSequenceNumber : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Refund refund = (Refund) o;

        if (id != null ? !id.equals(refund.id) : refund.id != null) return false;
        if (paymentId != null ? !paymentId.equals(refund.paymentId) : refund.paymentId != null) return false;
        if (amount != null ? !amount.equals(refund.amount) : refund.amount != null) return false;
        if (metadata != null ? !metadata.equals(refund.metadata) : refund.metadata != null) return false;
        if (source != null ? !source.equals(refund.source) : refund.source != null) return false;
        if (dateCreated != null ? !dateCreated.equals(refund.dateCreated) : refund.dateCreated != null) return false;
        return uniqueSequenceNumber != null ? uniqueSequenceNumber.equals(refund.uniqueSequenceNumber) : refund.uniqueSequenceNumber == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (paymentId != null ? paymentId.hashCode() : 0);
        result = 31 * result + (amount != null ? amount.hashCode() : 0);
        result = 31 * result + (metadata != null ? metadata.hashCode() : 0);
        result = 31 * result + (source != null ? source.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (uniqueSequenceNumber != null ? uniqueSequenceNumber.hashCode() : 0);
        return result;
    }
}
