package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Transaction Details class
 *
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class TransactionDetails {

    private String financialInstitution = null;
    private Float netReceivedAmount = null;
    private Float totalPaidAmount = null;
    private Float installmentAmount = null;
    private Float overpaidAmount = null;
    private String externalResourceUrl = null;
    private String paymentMethodReferenceId = null;


    public String getFinancialInstitution() {
        return financialInstitution;
    }

    public Float getNetReceivedAmount() {
        return netReceivedAmount;
    }

    public Float getTotalPaidAmount() {
        return totalPaidAmount;
    }

    public Float getInstallmentAmount() {
        return installmentAmount;
    }

    public Float getOverpaidAmount() {
        return overpaidAmount;
    }

    public String getExternalResourceUrl() {
        return externalResourceUrl;
    }

    public String getPaymentMethodReferenceId() {
        return paymentMethodReferenceId;
    }

    public void setFinancialInstitution(String financialInstitution) {
        this.financialInstitution = financialInstitution;
    }

    public void setNetReceivedAmount(Float netReceivedAmount) {
        this.netReceivedAmount = netReceivedAmount;
    }

    public void setTotalPaidAmount(Float totalPaidAmount) {
        this.totalPaidAmount = totalPaidAmount;
    }

    public void setInstallmentAmount(Float installmentAmount) {
        this.installmentAmount = installmentAmount;
    }

    public void setOverpaidAmount(Float overpaidAmount) {
        this.overpaidAmount = overpaidAmount;
    }

    public void setExternalResourceUrl(String externalResourceUrl) {
        this.externalResourceUrl = externalResourceUrl;
    }

    public void setPaymentMethodReferenceId(String paymentMethodReferenceId) {
        this.paymentMethodReferenceId = paymentMethodReferenceId;
    }

    @Override
    public String toString() {
        return "TransactionDetails ["
                + ((financialInstitution != null) ? "financialInstitution=" + financialInstitution + ", " : "")
                + ((netReceivedAmount != null) ? "netReceivedAmount=" + netReceivedAmount + ", " : "")
                + ((totalPaidAmount != null) ? "totalPaidAmount=" + totalPaidAmount + ", " : "")
                + ((installmentAmount != null) ? "installmentAmount=" + installmentAmount + ", " : "")
                + ((overpaidAmount != null) ? "overpaidAmount=" + overpaidAmount + ", " : "")
                + ((externalResourceUrl != null) ? "externalResourceUrl=" + externalResourceUrl + ", " : "")
                + ((paymentMethodReferenceId != null) ? "paymentMethodReferenceId=" + paymentMethodReferenceId : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TransactionDetails that = (TransactionDetails) o;

        if (financialInstitution != null ? !financialInstitution.equals(that.financialInstitution) : that.financialInstitution != null) return false;
        if (netReceivedAmount != null ? !netReceivedAmount.equals(that.netReceivedAmount) : that.netReceivedAmount != null) return false;
        if (totalPaidAmount != null ? !totalPaidAmount.equals(that.totalPaidAmount) : that.totalPaidAmount != null) return false;
        if (installmentAmount != null ? !installmentAmount.equals(that.installmentAmount) : that.installmentAmount != null) return false;
        if (overpaidAmount != null ? !overpaidAmount.equals(that.overpaidAmount) : that.overpaidAmount != null) return false;
        if (externalResourceUrl != null ? !externalResourceUrl.equals(that.externalResourceUrl) : that.externalResourceUrl != null) return false;
        return paymentMethodReferenceId != null ? paymentMethodReferenceId.equals(that.paymentMethodReferenceId) : that.paymentMethodReferenceId == null;
    }

    @Override
    public int hashCode() {
        int result = financialInstitution != null ? financialInstitution.hashCode() : 0;
        result = 31 * result + (netReceivedAmount != null ? netReceivedAmount.hashCode() : 0);
        result = 31 * result + (totalPaidAmount != null ? totalPaidAmount.hashCode() : 0);
        result = 31 * result + (installmentAmount != null ? installmentAmount.hashCode() : 0);
        result = 31 * result + (overpaidAmount != null ? overpaidAmount.hashCode() : 0);
        result = 31 * result + (externalResourceUrl != null ? externalResourceUrl.hashCode() : 0);
        result = 31 * result + (paymentMethodReferenceId != null ? paymentMethodReferenceId.hashCode() : 0);
        return result;
    }
}
