package ar.com.sdd.mercadopago.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.mercadopago.entity.MPError;
import ar.com.sdd.mercadopago.entity.MPPaging;
import ar.com.sdd.mercadopago.entity.Payment;
import ar.com.sdd.mercadopago.entity.Preference;
import org.apache.log4j.Logger;

import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;

public class MercadoPagoConnector implements RestSecurityManager {

    private static final Logger log = Logger.getLogger(MercadoPagoConnector.class);

    private static final String MP_BASE_URL = "https://api.mercadopago.com";

    private RestConnector restConnector;


    public MercadoPagoConnector() {
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        restConnector = new RestConnector(environment, this);
    }

    public Preference savePreference(String token, Preference request) throws RestConnectorException {
        log.debug("[savePreference] Request POST preferencia [" + request + "]");
        Preference response = restConnector.genericPost(request, Preference.class, MPError.class, "/checkout/preferences?access_token=" + token);
        log.debug("[savePreference] Response POST de la preferencia [" + response + "]");
        return response;
    }

    public MPPaging<Payment> searchPayment(String token, String externalReference) throws RestConnectorException {
        log.debug("[searchPayment] Request con externalReference [" + externalReference + "]");
        MPPaging<Payment> response = restConnector.genericGet(null, MPPaging.MPPagingPayment.class, MPError.class, "/v1/payments/search?external_reference=" + externalReference + "&access_token=" + token);
        log.debug("[searchPayment] Response con externalReference [" + externalReference + "],  [" + response + "]");
        return response;
    }


    public TokenOAuth2 getToken(String clientId, String clientSecret) throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "client_credentials");

        log.debug("[getToken] Por recuperar token con clientId [" + clientId + "], clientSecret [" + clientSecret + "]");

        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        RestConnector connector = new RestConnector(environment, null);
        TokenOAuth2 tokenOAuth2Response = connector.genericPost(form, TokenOAuth2.class, "/oauth/token", MediaType.APPLICATION_JSON, MediaType.APPLICATION_FORM_URLENCODED);

        log.debug("[getToken] Token recuperado [" + tokenOAuth2Response + "]");
        return tokenOAuth2Response;
    }

    @Override
    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        //Devuelvo el mismo builder sin modificarlo
        return builder;
    }

}
