package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Libre SDK
 * Differential Pricing class
 *
 * Created by Eduardo Paoletta on 11/9/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DifferentialPricing {

    private Integer id = null;


    public Integer getId() {
        return id;
    }

    public DifferentialPricing setId(Integer id) {
        this.id = id;
        return this;
    }

    @Override
    public String toString() {
        return "DifferentialPricing ["
                + ((id != null) ? "id=" + id : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DifferentialPricing that = (DifferentialPricing) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
