/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.mercadopago.entity.MPError;
import ar.com.sdd.mercadopago.entity.MPPaging;
import ar.com.sdd.mercadopago.entity.Payment;
import ar.com.sdd.mercadopago.entity.Preference;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import org.apache.log4j.Logger;

public class MercadoPagoConnector
implements RestSecurityManager {
    private static final Logger log = Logger.getLogger(MercadoPagoConnector.class);
    private static final String MP_BASE_URL = "https://api.mercadopago.com";
    private RestConnector restConnector;

    public MercadoPagoConnector() {
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        this.restConnector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public Preference savePreference(String token, Preference request) throws RestConnectorException {
        log.debug((Object)("[savePreference] Request POST preferencia [" + request + "]"));
        Preference response = (Preference)this.restConnector.genericPost((Object)request, Preference.class, MPError.class, "/checkout/preferences?access_token=" + token);
        log.debug((Object)("[savePreference] Response POST de la preferencia [" + response + "]"));
        return response;
    }

    public MPPaging<Payment> searchPayment(String token, String externalReference) throws RestConnectorException {
        log.debug((Object)("[searchPayment] Request con externalReference [" + externalReference + "]"));
        MPPaging response = (MPPaging)this.restConnector.genericGet(null, MPPaging.MPPagingPayment.class, MPError.class, "/v1/payments/search?external_reference=" + externalReference + "&access_token=" + token);
        log.debug((Object)("[searchPayment] Response con externalReference [" + externalReference + "],  [" + response + "]"));
        return response;
    }

    public TokenOAuth2 getToken(String clientId, String clientSecret) throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "client_credentials");
        log.debug((Object)("[getToken] Por recuperar token con clientId [" + clientId + "], clientSecret [" + clientSecret + "]"));
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = MP_BASE_URL;
        RestConnector connector = new RestConnector(environment, null);
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/oauth/token", "application/json", "application/x-www-form-urlencoded");
        log.debug((Object)("[getToken] Token recuperado [" + tokenOAuth2Response + "]"));
        return tokenOAuth2Response;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        return builder;
    }
}

