package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Mercado Libre SDK
 * Payment methods class
 * <p>
 * Created by Eduardo Paoletta on 11/9/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PaymentMethods {

    private ArrayList<ExcludedPaymentMethod> excludedPaymentMethods = null;
    private ArrayList<ExcludedPaymentType> excludedPaymentTypes = null;
    private String defaultPaymentMethodId = null;
    private Integer installments = null;
    private Integer defaultInstallments = null;

    public PaymentMethods() {

    }

    public PaymentMethods(ArrayList<ExcludedPaymentMethod> excludedPaymentMethods, ArrayList<ExcludedPaymentType> excludedPaymentTypes) {
        this.excludedPaymentMethods = excludedPaymentMethods;
        this.excludedPaymentTypes = excludedPaymentTypes;
    }

    public PaymentMethods(ArrayList<ExcludedPaymentMethod> excludedPaymentMethods, ArrayList<ExcludedPaymentType> excludedPaymentTypes, Integer installments) {
        this.excludedPaymentMethods = excludedPaymentMethods;
        this.excludedPaymentTypes = excludedPaymentTypes;
    }


    public List<ExcludedPaymentMethod> getExcludedPaymentMethods() {
        return excludedPaymentMethods;
    }

    public PaymentMethods setExcludedPaymentMethods(ArrayList<ExcludedPaymentMethod> excludedPaymentMethods) {
        this.excludedPaymentMethods = excludedPaymentMethods;
        return this;
    }

    public List<ExcludedPaymentMethod> appendExcludedPaymentMethod(ExcludedPaymentMethod excludedPaymentMethod) {
        if (excludedPaymentMethods == null) {
            excludedPaymentMethods = new ArrayList<ExcludedPaymentMethod>();
        }
        excludedPaymentMethods.add(excludedPaymentMethod);
        return getExcludedPaymentMethods();
    }

    public ArrayList<ExcludedPaymentType> getExcludedPaymentTypes() {
        return excludedPaymentTypes;
    }

    public PaymentMethods setExcludedPaymentTypes(ArrayList<ExcludedPaymentType> excludedPaymentTypes) {
        this.excludedPaymentTypes = excludedPaymentTypes;
        return this;
    }

    public List<ExcludedPaymentType> appendExcludedPaymentTypes(ExcludedPaymentType excludedPaymentType) {
        if (excludedPaymentTypes == null) {
            excludedPaymentTypes = new ArrayList<ExcludedPaymentType>();
        }
        excludedPaymentTypes.add(excludedPaymentType);
        return getExcludedPaymentTypes();
    }

    public String getDefaultPaymentMethodId() {
        return defaultPaymentMethodId;
    }

    public PaymentMethods setDefaultPaymentMethodId(String defaultPaymentMethodId) {
        this.defaultPaymentMethodId = defaultPaymentMethodId;
        return this;
    }

    public Integer getInstallments() {
        return installments;
    }

    public PaymentMethods setInstallments(Integer installments) {
        this.installments = installments;
        return this;
    }

    public Integer getDefaultInstallments() {
        return defaultInstallments;
    }

    public PaymentMethods setDefaultInstallments(Integer defaultInstallments) {
        this.defaultInstallments = defaultInstallments;
        return this;
    }


    @Override
    public String toString() {
        return "PaymentMethods ["
                + ((excludedPaymentMethods != null) ? "excludedPaymentMethods=" + Arrays.toString(excludedPaymentMethods.toArray()) + ", " : "")
                + ((excludedPaymentTypes != null) ? "excludedPaymentTypes=" + Arrays.toString(excludedPaymentTypes.toArray()) + ", " : "")
                + ((defaultPaymentMethodId != null) ? "defaultPaymentMethodId=" + defaultPaymentMethodId + ", " : "")
                + ((installments != null) ? "installments=" + installments + ", " : "")
                + ((defaultInstallments != null) ? "defaultInstallments=" + defaultInstallments : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentMethods that = (PaymentMethods) o;

        if (excludedPaymentMethods != null ? !excludedPaymentMethods.equals(that.excludedPaymentMethods) : that.excludedPaymentMethods != null) return false;
        if (excludedPaymentTypes != null ? !excludedPaymentTypes.equals(that.excludedPaymentTypes) : that.excludedPaymentTypes != null) return false;
        if (defaultPaymentMethodId != null ? !defaultPaymentMethodId.equals(that.defaultPaymentMethodId) : that.defaultPaymentMethodId != null) return false;
        if (installments != null ? !installments.equals(that.installments) : that.installments != null) return false;
        return defaultInstallments != null ? defaultInstallments.equals(that.defaultInstallments) : that.defaultInstallments == null;
    }

    @Override
    public int hashCode() {
        int result = excludedPaymentMethods != null ? excludedPaymentMethods.hashCode() : 0;
        result = 31 * result + (excludedPaymentTypes != null ? excludedPaymentTypes.hashCode() : 0);
        result = 31 * result + (defaultPaymentMethodId != null ? defaultPaymentMethodId.hashCode() : 0);
        result = 31 * result + (installments != null ? installments.hashCode() : 0);
        result = 31 * result + (defaultInstallments != null ? defaultInstallments.hashCode() : 0);
        return result;
    }
}
