
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Transactions {

    @JsonProperty("canceled")
    private Long canceled;
    @JsonProperty("completed")
    private Long completed;
    @JsonProperty("period")
    private String period;
    @JsonProperty("ratings")
    private Ratings ratings;
    @JsonProperty("total")
    private Long total;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("canceled")
    public Long getCanceled() {
        return canceled;
    }

    @JsonProperty("canceled")
    public void setCanceled(Long canceled) {
        this.canceled = canceled;
    }

    @JsonProperty("completed")
    public Long getCompleted() {
        return completed;
    }

    @JsonProperty("completed")
    public void setCompleted(Long completed) {
        this.completed = completed;
    }

    @JsonProperty("period")
    public String getPeriod() {
        return period;
    }

    @JsonProperty("period")
    public void setPeriod(String period) {
        this.period = period;
    }

    @JsonProperty("ratings")
    public Ratings getRatings() {
        return ratings;
    }

    @JsonProperty("ratings")
    public void setRatings(Ratings ratings) {
        this.ratings = ratings;
    }

    @JsonProperty("total")
    public Long getTotal() {
        return total;
    }

    @JsonProperty("total")
    public void setTotal(Long total) {
        this.total = total;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "Transactions ["
                + ((canceled != null) ? "canceled=" + canceled + ", " : "")
                + ((completed != null) ? "completed=" + completed + ", " : "")
                + ((period != null) ? "period=" + period + ", " : "")
                + ((ratings != null) ? "ratings=" + ratings + ", " : "")
                + ((total != null) ? "total=" + total + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
