package ar.com.sdd.mercadopago.entity;

import ar.com.sdd.mercadopago.entity.preference.BackUrls;
import ar.com.sdd.mercadopago.entity.preference.DifferentialPricing;
import ar.com.sdd.mercadopago.entity.preference.Item;
import ar.com.sdd.mercadopago.entity.preference.Payer;
import ar.com.sdd.mercadopago.entity.preference.PaymentMethods;
import ar.com.sdd.mercadopago.entity.preference.Shipments;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

/**
 * Mercado Pago MercadoPago
 * This resource allows you to set up, during the Payment process, all the item information,
 * any accepted means of Payment and many other options.
 * <p>
 * Created by Eduardo Paoletta on 11/9/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Preference {

    public enum OperationType {
        regular_payment,
        money_transfer
    }

    public enum AutoReturn {
        approved,
        all
    }

    private ArrayList<Item> items = null;
    private Payer payer = null;
    private PaymentMethods paymentMethods = null;
    private Shipments shipments = null;
    private BackUrls backUrls = null;
    private String notificationUrl = null;
    private String id = null;
    private String initPoint = null;
    private String sandboxInitPoint = null;
    private Date dateCreated = null;
    private OperationType operationType = null;
    private String additionalInfo = null;
    private AutoReturn autoReturn = null;
    private String externalReference = null;
    private Boolean expires = null;
    private Date expirationDateFrom = null;
    private Date expirationDateTo = null;
    private BigDecimal collectorId = null;
    private BigDecimal clientId = null;
    private String marketplace = null;
    private BigDecimal marketplaceFee = null;
    private DifferentialPricing differentialPricing = null;


    public ArrayList<Item> getItems() {
        return items;
    }

    public Preference setItems(ArrayList<Item> items) {
        this.items = items;
        return this;
    }

    public Preference appendItem(Item item) {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        items.add(item);
        return this;
    }

    public Payer getPayer() {
        return payer;
    }

    public Preference setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public PaymentMethods getPaymentMethods() {
        return paymentMethods;
    }

    public Preference setPaymentMethods(PaymentMethods paymentMethods) {
        this.paymentMethods = paymentMethods;
        return this;
    }

    public Shipments getShipments() {
        return shipments;
    }

    public Preference setShipments(Shipments shipments) {
        this.shipments = shipments;
        return this;
    }

    public BackUrls getBackUrls() {
        return backUrls;
    }

    public Preference setBackUrls(BackUrls backUrls) {
        this.backUrls = backUrls;
        return this;
    }

    public String getNotificationUrl() {
        return notificationUrl;
    }

    public Preference setNotificationUrl(String notificationUrl) {
        this.notificationUrl = notificationUrl;
        return this;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getInitPoint() {
        return initPoint;
    }

    public void setInitPoint(String initPoint) {
        this.initPoint = initPoint;
    }

    public String getSandboxInitPoint() {
        return sandboxInitPoint;
    }

    public void setSandboxInitPoint(String sandboxInitPoint) {
        this.sandboxInitPoint = sandboxInitPoint;
    }

    public Date getDateCreated() {
        return dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public OperationType getOperationType() {
        return operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }

    public String getAdditionalInfo() {
        return additionalInfo;
    }

    public Preference setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
        return this;
    }

    public AutoReturn getAutoReturn() {
        return autoReturn;
    }

    public Preference setAutoReturn(AutoReturn autoReturn) {
        this.autoReturn = autoReturn;
        return this;
    }

    public String getExternalReference() {
        return externalReference;
    }

    public Preference setExternalReference(String externalReference) {
        this.externalReference = externalReference;
        return this;
    }

    public Boolean getExpires() {
        return expires;
    }

    public Preference setExpires(Boolean expires) {
        this.expires = expires;
        return this;
    }

    public Date getExpirationDateFrom() {
        return expirationDateFrom;
    }

    public Preference setExpirationDateFrom(Date expirationDateFrom) {
        this.expirationDateFrom = expirationDateFrom;
        return this;
    }

    public Date getExpirationDateTo() {
        return expirationDateTo;
    }

    public Preference setExpirationDateTo(Date expirationDateTo) {
        this.expirationDateTo = expirationDateTo;
        return this;
    }

    public BigDecimal getCollectorId() {
        return collectorId;
    }

    public void setCollectorId(BigDecimal collectorId) {
        this.collectorId = collectorId;
    }

    public BigDecimal getClientId() {
        return clientId;
    }

    public void setClientId(BigDecimal clientId) {
        this.clientId = clientId;
    }

    public String getMarketplace() {
        return marketplace;
    }

    public Preference setMarketplace(String marketplace) {
        this.marketplace = marketplace;
        return this;
    }

    public BigDecimal getMarketplaceFee() {
        return marketplaceFee;
    }

    public Preference setMarketplaceFee(BigDecimal marketplaceFee) {
        this.marketplaceFee = marketplaceFee;
        return this;
    }

    public DifferentialPricing getDifferentialPricing() {
        return differentialPricing;
    }

    public Preference setDifferentialPricing(DifferentialPricing differentialPricing) {
        this.differentialPricing = differentialPricing;
        return this;
    }

    @Override
    public String toString() {
        return "Preference ["
                + ((items != null) ? "items=" + Arrays.toString(items.toArray()) + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((paymentMethods != null) ? "paymentMethods=" + paymentMethods + ", " : "")
                + ((shipments != null) ? "shipments=" + shipments + ", " : "")
                + ((backUrls != null) ? "backUrls=" + backUrls + ", " : "")
                + ((notificationUrl != null) ? "notificationUrl=" + notificationUrl + ", " : "")
                + ((id != null) ? "id=" + id + ", " : "")
                + ((initPoint != null) ? "initPoint=" + initPoint + ", " : "")
                + ((sandboxInitPoint != null) ? "sandboxInitPoint=" + sandboxInitPoint + ", " : "")
                + ((dateCreated != null) ? "dateCreated=" + dateCreated + ", " : "")
                + ((operationType != null) ? "operationType=" + operationType + ", " : "")
                + ((additionalInfo != null) ? "additionalInfo=" + additionalInfo + ", " : "")
                + ((autoReturn != null) ? "autoReturn=" + autoReturn + ", " : "")
                + ((externalReference != null) ? "externalReference=" + externalReference + ", " : "")
                + ((expires != null) ? "expires=" + expires + ", " : "")
                + ((expirationDateFrom != null) ? "expirationDateFrom=" + expirationDateFrom + ", " : "")
                + ((expirationDateTo != null) ? "expirationDateTo=" + expirationDateTo + ", " : "")
                + ((collectorId != null) ? "collectorId=" + collectorId + ", " : "")
                + ((clientId != null) ? "clientId=" + clientId + ", " : "")
                + ((marketplace != null) ? "marketplace=" + marketplace + ", " : "")
                + ((marketplaceFee != null) ? "marketplaceFee=" + marketplaceFee + ", " : "")
                + ((differentialPricing != null) ? "differentialPricing=" + differentialPricing : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Preference that = (Preference) o;

        if (items != null ? !items.equals(that.items) : that.items != null) return false;
        if (payer != null ? !payer.equals(that.payer) : that.payer != null) return false;
        if (paymentMethods != null ? !paymentMethods.equals(that.paymentMethods) : that.paymentMethods != null) return false;
        if (shipments != null ? !shipments.equals(that.shipments) : that.shipments != null) return false;
        if (backUrls != null ? !backUrls.equals(that.backUrls) : that.backUrls != null) return false;
        if (notificationUrl != null ? !notificationUrl.equals(that.notificationUrl) : that.notificationUrl != null) return false;
        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (initPoint != null ? !initPoint.equals(that.initPoint) : that.initPoint != null) return false;
        if (sandboxInitPoint != null ? !sandboxInitPoint.equals(that.sandboxInitPoint) : that.sandboxInitPoint != null) return false;
        if (dateCreated != null ? !dateCreated.equals(that.dateCreated) : that.dateCreated != null) return false;
        if (operationType != that.operationType) return false;
        if (additionalInfo != null ? !additionalInfo.equals(that.additionalInfo) : that.additionalInfo != null) return false;
        if (autoReturn != that.autoReturn) return false;
        if (externalReference != null ? !externalReference.equals(that.externalReference) : that.externalReference != null) return false;
        if (expires != null ? !expires.equals(that.expires) : that.expires != null) return false;
        if (expirationDateFrom != null ? !expirationDateFrom.equals(that.expirationDateFrom) : that.expirationDateFrom != null) return false;
        if (expirationDateTo != null ? !expirationDateTo.equals(that.expirationDateTo) : that.expirationDateTo != null) return false;
        if (collectorId != null ? !collectorId.equals(that.collectorId) : that.collectorId != null) return false;
        if (clientId != null ? !clientId.equals(that.clientId) : that.clientId != null) return false;
        if (marketplace != null ? !marketplace.equals(that.marketplace) : that.marketplace != null) return false;
        if (marketplaceFee != null ? !marketplaceFee.equals(that.marketplaceFee) : that.marketplaceFee != null) return false;
        return differentialPricing != null ? differentialPricing.equals(that.differentialPricing) : that.differentialPricing == null;
    }

    @Override
    public int hashCode() {
        int result = items != null ? items.hashCode() : 0;
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (paymentMethods != null ? paymentMethods.hashCode() : 0);
        result = 31 * result + (shipments != null ? shipments.hashCode() : 0);
        result = 31 * result + (backUrls != null ? backUrls.hashCode() : 0);
        result = 31 * result + (notificationUrl != null ? notificationUrl.hashCode() : 0);
        result = 31 * result + (id != null ? id.hashCode() : 0);
        result = 31 * result + (initPoint != null ? initPoint.hashCode() : 0);
        result = 31 * result + (sandboxInitPoint != null ? sandboxInitPoint.hashCode() : 0);
        result = 31 * result + (dateCreated != null ? dateCreated.hashCode() : 0);
        result = 31 * result + (operationType != null ? operationType.hashCode() : 0);
        result = 31 * result + (additionalInfo != null ? additionalInfo.hashCode() : 0);
        result = 31 * result + (autoReturn != null ? autoReturn.hashCode() : 0);
        result = 31 * result + (externalReference != null ? externalReference.hashCode() : 0);
        result = 31 * result + (expires != null ? expires.hashCode() : 0);
        result = 31 * result + (expirationDateFrom != null ? expirationDateFrom.hashCode() : 0);
        result = 31 * result + (expirationDateTo != null ? expirationDateTo.hashCode() : 0);
        result = 31 * result + (collectorId != null ? collectorId.hashCode() : 0);
        result = 31 * result + (clientId != null ? clientId.hashCode() : 0);
        result = 31 * result + (marketplace != null ? marketplace.hashCode() : 0);
        result = 31 * result + (marketplaceFee != null ? marketplaceFee.hashCode() : 0);
        result = 31 * result + (differentialPricing != null ? differentialPricing.hashCode() : 0);
        return result;
    }
}
