package ar.com.sdd.mercadopago.entity.merchantorder;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Merchant Order Payer class
 * <p>
 * Created by Eduardo Paoletta on 12/13/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Payer {

    private String id = null;
    private String email = null;
    private String nickname = null;

    public String getId() {
        return this.id;
    }

    public Payer setId(String id) {
        this.id = id;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Payer setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getNickname() {
        return this.nickname;
    }

    public Payer setNickname(String nickname) {
        this.nickname = nickname;
        return this;
    }

    @Override
    public String toString() {
        return "Payer ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((nickname != null) ? "nickname=" + nickname : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Payer payer = (Payer) o;

        if (id != null ? !id.equals(payer.id) : payer.id != null) return false;
        if (email != null ? !email.equals(payer.email) : payer.email != null) return false;
        return nickname != null ? nickname.equals(payer.nickname) : payer.nickname == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (email != null ? email.hashCode() : 0);
        result = 31 * result + (nickname != null ? nickname.hashCode() : 0);
        return result;
    }
}
