package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.math.BigDecimal;

/**
 * Mercado Libre MercadoPago
 * Item class
 * <p>
 * Created by Eduardo Paoletta on 11/23/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class Item {

    private String id = null;
    private String title = null;
    private String description = null;
    private String pictureUrl = null;
    private String categoryId = null;
    private Integer quantity = null;
    private BigDecimal unitPrice = new BigDecimal("0");


    public String getId() {
        return id;
    }

    public Item setId(String id) {
        this.id = id;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public Item setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Item setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getPictureUrl() {
        return pictureUrl;
    }

    public Item setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
        return this;
    }

    public String getCategoryId() {
        return categoryId;
    }

    public Item setCategoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    public Integer getQuantity() {
        return quantity;
    }

    public Item setQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public Item setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @Override
    public String toString() {
        return "Item ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((title != null) ? "title=" + title + ", " : "")
                + ((description != null) ? "description=" + description + ", " : "")
                + ((pictureUrl != null) ? "pictureUrl=" + pictureUrl + ", " : "")
                + ((categoryId != null) ? "categoryId=" + categoryId + ", " : "")
                + ((quantity != null) ? "quantity=" + quantity + ", " : "")
                + ((unitPrice != null) ? "unitPrice=" + unitPrice : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        Item item = (Item) o;

        if (id != null ? !id.equals(item.id) : item.id != null) return false;
        if (title != null ? !title.equals(item.title) : item.title != null) return false;
        if (description != null ? !description.equals(item.description) : item.description != null) return false;
        if (pictureUrl != null ? !pictureUrl.equals(item.pictureUrl) : item.pictureUrl != null) return false;
        if (categoryId != null ? !categoryId.equals(item.categoryId) : item.categoryId != null) return false;
        if (quantity != null ? !quantity.equals(item.quantity) : item.quantity != null) return false;
        return unitPrice != null ? unitPrice.equals(item.unitPrice) : item.unitPrice == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (title != null ? title.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (pictureUrl != null ? pictureUrl.hashCode() : 0);
        result = 31 * result + (categoryId != null ? categoryId.hashCode() : 0);
        result = 31 * result + (quantity != null ? quantity.hashCode() : 0);
        result = 31 * result + (unitPrice != null ? unitPrice.hashCode() : 0);
        return result;
    }
}
