package ar.com.sdd.mercadopago.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Arrays;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MercadoPagoReportConfiguration {

    private String fileNamePrefix;
    private Boolean showFeePrevision;
    private Boolean showChargebackCancel;
    private Boolean detailed;
    private Boolean scheduled;
    private Boolean couponDetailed;
    private Boolean shippingDetail;
    private Boolean refundDetailed;
    private Boolean extended;
    private Boolean includeWithdraw;
    private MercadoPagoReportConfigurationFrequency frequency;
    private String separator;
    private String sftpInfo;
    private MercadoPagoReportConfigurationColumn[] columns;
    private Boolean customValuesUnquote;
    private String  displayTimezone;
    private String[]  notificationEmailList;


    public String getFileNamePrefix() {
        return fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }

    public Boolean getShowFeePrevision() {
        return showFeePrevision;
    }

    public void setShowFeePrevision(Boolean showFeePrevision) {
        this.showFeePrevision = showFeePrevision;
    }

    public Boolean getShowChargebackCancel() {
        return showChargebackCancel;
    }

    public void setShowChargebackCancel(Boolean showChargebackCancel) {
        this.showChargebackCancel = showChargebackCancel;
    }

    public Boolean getDetailed() {
        return detailed;
    }

    public void setDetailed(Boolean detailed) {
        this.detailed = detailed;
    }

    public Boolean getScheduled() {
        return scheduled;
    }

    public void setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
    }

    public Boolean getCouponDetailed() {
        return couponDetailed;
    }

    public void setCouponDetailed(Boolean couponDetailed) {
        this.couponDetailed = couponDetailed;
    }

    public Boolean getShippingDetail() {
        return shippingDetail;
    }

    public void setShippingDetail(Boolean shippingDetail) {
        this.shippingDetail = shippingDetail;
    }

    public Boolean getRefundDetailed() {
        return refundDetailed;
    }

    public void setRefundDetailed(Boolean refundDetailed) {
        this.refundDetailed = refundDetailed;
    }

    public Boolean getExtended() {
        return extended;
    }

    public void setExtended(Boolean extended) {
        this.extended = extended;
    }

    public MercadoPagoReportConfigurationFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(MercadoPagoReportConfigurationFrequency frequency) {
        this.frequency = frequency;
    }

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSftpInfo() {
        return sftpInfo;
    }

    public void setSftpInfo(String sftpInfo) {
        this.sftpInfo = sftpInfo;
    }

    public Boolean getIncludeWithdraw() {
        return includeWithdraw;
    }

    public void setIncludeWithdraw(Boolean includeWithdraw) {
        this.includeWithdraw = includeWithdraw;
    }

    public MercadoPagoReportConfigurationColumn[] getColumns() {
        return columns;
    }

    public void setColumns(MercadoPagoReportConfigurationColumn[] columns) {
        this.columns = columns;
    }

    public Boolean getCustomValuesUnquote() {
        return customValuesUnquote;
    }

    public void setCustomValuesUnquote(Boolean customValuesUnquote) {
        this.customValuesUnquote = customValuesUnquote;
    }

    @Override
    public String toString() {
        return "MercadoPagoReportConfiguration [" +
                "fileNamePrefix=" + fileNamePrefix +
                ", showFeePrevision=" + showFeePrevision +
                ", showChargebackCancel=" + showChargebackCancel +
                ", detailed=" + detailed +
                ", scheduled=" + scheduled +
                ", couponDetailed=" + couponDetailed +
                ", shippingDetail=" + shippingDetail +
                ", refundDetailed=" + refundDetailed +
                ", extended=" + extended +
                ", includeWithdraw=" + includeWithdraw +
                ", frequency=" + frequency +
                ", separator=" + separator +
                ", sftpInfo=" + sftpInfo +
                ", columns=" + (columns == null ? columns : Arrays.toString(columns)) +
                ", customValuesUnquote=" + customValuesUnquote +
                ", displayTimezone=" + displayTimezone +
                ", notificationEmailList=" + (notificationEmailList == null ? notificationEmailList : Arrays.toString(notificationEmailList)) +
                ']';
    }
}
