
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Metrics {

    @JsonProperty("sales")
    private Sales sales;
    @JsonProperty("claims")
    private Claims claims;
    @JsonProperty("delayed_handling_time")
    private DelayedHandlingTime delayedHandlingTime;
    @JsonProperty("cancellations")
    private Cancellations cancellations;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("sales")
    public Sales getSales() {
        return sales;
    }

    @JsonProperty("sales")
    public void setSales(Sales sales) {
        this.sales = sales;
    }

    @JsonProperty("claims")
    public Claims getClaims() {
        return claims;
    }

    @JsonProperty("claims")
    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    @JsonProperty("delayed_handling_time")
    public DelayedHandlingTime getDelayedHandlingTime() {
        return delayedHandlingTime;
    }

    @JsonProperty("delayed_handling_time")
    public void setDelayedHandlingTime(DelayedHandlingTime delayedHandlingTime) {
        this.delayedHandlingTime = delayedHandlingTime;
    }

    @JsonProperty("cancellations")
    public Cancellations getCancellations() {
        return cancellations;
    }

    @JsonProperty("cancellations")
    public void setCancellations(Cancellations cancellations) {
        this.cancellations = cancellations;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "Metrics ["
                + ((sales != null) ? "sales=" + sales + ", " : "")
                + ((claims != null) ? "claims=" + claims + ", " : "")
                + ((delayedHandlingTime != null) ? "delayedHandlingTime=" + delayedHandlingTime + ", " : "")
                + ((cancellations != null) ? "cancellations=" + cancellations + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
