
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class SellerReputation {

    @JsonProperty("level_id")
    private Object levelId;
    @JsonProperty("power_seller_status")
    private Object powerSellerStatus;
    @JsonProperty("transactions")
    private Transactions transactions;
    @JsonProperty("metrics")
    private Metrics metrics;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("level_id")
    public Object getLevelId() {
        return levelId;
    }

    @JsonProperty("level_id")
    public void setLevelId(Object levelId) {
        this.levelId = levelId;
    }

    @JsonProperty("power_seller_status")
    public Object getPowerSellerStatus() {
        return powerSellerStatus;
    }

    @JsonProperty("power_seller_status")
    public void setPowerSellerStatus(Object powerSellerStatus) {
        this.powerSellerStatus = powerSellerStatus;
    }

    @JsonProperty("transactions")
    public Transactions getTransactions() {
        return transactions;
    }

    @JsonProperty("transactions")
    public void setTransactions(Transactions transactions) {
        this.transactions = transactions;
    }

    @JsonProperty("metrics")
    public Metrics getMetrics() {
        return metrics;
    }

    @JsonProperty("metrics")
    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "SellerReputation ["
                + ((levelId != null) ? "levelId=" + levelId + ", " : "")
                + ((powerSellerStatus != null) ? "powerSellerStatus=" + powerSellerStatus + ", " : "")
                + ((transactions != null) ? "transactions=" + transactions + ", " : "")
                + ((metrics != null) ? "metrics=" + metrics + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
