package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Excluded Payment Types class
 * <p>
 * Created by Eduardo Paoletta on 12/14/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ExcludedPaymentType {

    private String id = null;

    public ExcludedPaymentType() {
    }

    public ExcludedPaymentType(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ExcludedPaymentType setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public String toString() {
        return "ExcludedPaymentType ["
                + ((id != null) ? "id=" + id : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {

        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ExcludedPaymentType that = (ExcludedPaymentType) o;

        return id != null ? id.equals(that.id) : that.id == null;
    }

    @Override
    public int hashCode() {
        return id != null ? id.hashCode() : 0;
    }
}
