
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Ratings {

    @JsonProperty("negative")
    private Long negative;
    @JsonProperty("neutral")
    private Long neutral;
    @JsonProperty("positive")
    private Long positive;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("negative")
    public Long getNegative() {
        return negative;
    }

    @JsonProperty("negative")
    public void setNegative(Long negative) {
        this.negative = negative;
    }

    @JsonProperty("neutral")
    public Long getNeutral() {
        return neutral;
    }

    @JsonProperty("neutral")
    public void setNeutral(Long neutral) {
        this.neutral = neutral;
    }

    @JsonProperty("positive")
    public Long getPositive() {
        return positive;
    }

    @JsonProperty("positive")
    public void setPositive(Long positive) {
        this.positive = positive;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "Ratings ["
                + ((negative != null) ? "negative=" + negative + ", " : "")
                + ((neutral != null) ? "neutral=" + neutral + ", " : "")
                + ((positive != null) ? "positive=" + positive + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
