
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ShoppingCart {

    @JsonProperty("buy")
    private String buy;
    @JsonProperty("sell")
    private String sell;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("buy")
    public String getBuy() {
        return buy;
    }

    @JsonProperty("buy")
    public void setBuy(String buy) {
        this.buy = buy;
    }

    @JsonProperty("sell")
    public String getSell() {
        return sell;
    }

    @JsonProperty("sell")
    public void setSell(String sell) {
        this.sell = sell;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "ShoppingCart ["
                + ((buy != null) ? "buy=" + buy + ", " : "")
                + ((sell != null) ? "sell=" + sell + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
