package ar.com.sdd.mercadopago.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MPErrorResponse {

    @JsonProperty("message")
    private String message;

    @JsonProperty("error")
    private String error;

    @JsonProperty("status")
    private Integer status;

    @JsonProperty("cause")
    private List<MPErrorCause> cause;

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getError() {
        return error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public List<MPErrorCause> getCause() {
        return cause;
    }

    public void setCause(List<MPErrorCause> cause) {
        this.cause = cause;
    }

    @Override
    public String toString() {
        return "MPErrorResponse [" +
                ((message != null) ? "message='" + message + "', " : "") +
                ((error != null) ? "error='" + error + "', " : "") +
                ((status != null) ? "status=" + status + ", " : "") +
                ((cause != null) ? "cause=" + Arrays.toString(cause.toArray()) + ", " : "") +
                "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MPErrorResponse that = (MPErrorResponse) o;
        return Objects.equals(message, that.message) && Objects.equals(error, that.error) && Objects.equals(status, that.status) && Objects.equals(cause, that.cause);
    }

    @Override
    public int hashCode() {
        return Objects.hash(message, error, status, cause);
    }
}
