package ar.com.sdd.mercadopago.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MercadoPagoReportConfigurationColumn {
    /*
    * Valid Keys

    Para Transacciones:
    https://www.mercadopago.com.ar/developers/es/docs/subscriptions/additional-content/reports/account-money/report-fields

    EXTERNAL_REFERENCE: ID que ayuda a identificar el origen de la operación. Por ejemplo, puede ser la venta a través del ID de la orden o el envío (si es una compra de carrito) o del ID propio provisto por el vendedor en caso de una integración externa.
            Ten en cuenta que es posible que este campo esté vacío para algunos casos como el pago de facturas o un envío de dinero, entre otros.

    SOURCE_ID:	ID de operación en Mercado Pago (por ejemplo, el pago de una venta).
    USER_ID:	Código de la cuenta del vendedor. (Cust ID).
    PAYMENT_METHOD:	Consulta los medios de pago disponibles según el país con el que operes en Mercado Pago.
    PAYMENT_METHOD_TYPE:	Tipo de medio de pago.
                Puede ser:
                credit_card: tarjeta de crédito.
                debit_card: tarjeta de débito.
                bank_transfer: transferencia.
                atm: cajero
                ticket: efectivo
                available_money: es el dinero que otros usuarios de Mercado Pago pueden usar para comprar y pagar.

     SITE:	País de origen de la cuenta de Mercado Pago: MLA: Argentina
     TRANSACTION_TYPE:	Tipo de operación.
                Puede ser:

                Pago aprobado (SETTLEMENT): pago aprobado.
                Devolución de dinero (REFUND): pago devuelto total o parcialmente.
                Contracargo (CHARGEBACK): el comprador hizo un contracargo (desconocimiento del pago) en su tarjeta de crédito.
                Reclamo (DISPUTE): el comprador inició un reclamo por ese pago.
                Retiro de cuenta bancaria (WITHDRAWAL): retiro a la cuenta bancaria.
                Retiro a la cuenta bancaria cancelado (WITHDRAWAL_CANCEL): retiro a la cuenta bancaria que fue cancelado.
                Retiro de efectivo (PAYOUT): extracción en efectivo de dinero disponible en Mercado Pago.

      TRANSACTION_AMOUNT	Monto bruto de la operación.
      TRANSACTION_CURRENCY:	Puede tomar algunos de estos valores según corresponda:
                MXN (Peso mexicano)
                CLP (Peso Chileno)
                ARS (Peso Argentino)
                BRL (Real Brasilero)
                PEN (Sol Peruano)
                COP (Peso Colombiano)
                UYU (Peso Uruguayo)
                VES (Bolivar Venezolano)

        SELLER_AMOUNT:	Monto recibido por compras por split.
        TRANSACTION_DATE:	Fecha de creación de la operación.
        FEE_AMOUNT:	Sumatoria de las comisiones de procesamiento, envíos, financiamiento y cupones si fue asumido por el vendedor. Incluyen IVA.
        SETTLEMENT_NET_AMOUNT:	Monto neto de la operación que impactó en el dinero. Se le descontaron todas las comisiones involucradas del Valor de la compra (TRANSACTION_AMOUNT).
        SETTLEMENT_CURRENCY: Moneda de la liquidación.	Puede tomar algunos de estos valores según corresponda:
                MXN (Peso mexicano)
                CLP (Peso Chileno)
                ARS (Peso Argentino)
                BRL (Real Brasilero)
                PEN (Sol Peruano)
                COP (Peso Colombiano)
                UYU (Peso Uruguayo)
                VES (Bolivar Venezolano)
        SETTLEMENT_DATE:	Fecha de aprobación de la transacción.
        REAL_AMOUNT:	Monto neto de la operación, si es un pago aprobado settlement, se le descuentan los montos por contracargos, reclamos o devoluciones.
        COUPON_AMOUNT:	Monto del cupón de descuento. Solo se descuenta del monto bruto o valor de la compra (TRANSACTION_AMOUNT) si está provisto por el vendedor.
        METADATA:	Datos extras como por ejemplo el ID de las devoluciones parciales o datos provistos por el vendedor en caso de tener una integración externa.
        MKP_FEE_AMOUNT: 	Comisión de Mercado Libre. Incluye IVA.
        FINANCING_FEE_AMOUNT:	Costo por ofrecer cuotas sin interés.
        SHIPPING_FEE_AMOUNT	Costo de envío.
        TAXES_AMOUNT:	Impuestos cobrados por retenciones de Ingresos Brutos, IVA, Ganancias; e impuestos sobre los Créditos y Débitos, entre otros. Ver más detalle sobre retenciones y percepciones.Ver más detalle sobre retenciones y percepciones
        INSTALLMENTS:	Cantidad de cuotas en las que fue realizada la operación.
        TAX_DETAIL:	Descripción del impuesto retenido por operación en los impuestos cobrados por retenciones IIBB TAXES_AMOUNT.
                Puede tomar los siguientes valores según la jurisdicción:
                cordoba
                corrientes
                mendoza
                la_pampa
                santa_fe
                tucuman
                entre_rios
                catamarca
                neuquen
                santiago_del_estero
                rio_negro
                jujuy

        POS_ID:	ID de caja si el pago se realiza a través de un comercio físico.
        POS_NAME:	Nombre de caja para el pago realizado a través de un comercio físico.
        EXTERNAL_POS_ID:	ID de caja definido por el usuario para el pago realizado a través de un comercio físico.
        STORE_ID:	ID de sucursal si el pago se realiza a través de un comercio físico.
        STORE_NAME:	Nombre de sucursal para el pago realizado a través de un comercio físico.
        EXTERNAL_STORE_ID:	ID de sucursal definido por el usuario para el pago realizado a través de un comercio físico.
        ORDER_ID:	Orden de compra.
        SHIPPING_ID:	Identificador de envío.
        SHIPMENT_MODE:	Modalidad de envío.
        PACK_ID:	Identificador del paquete en el carrito.
        TAXES_DISAGGREGATED:	Impuestos desagregados en formato JSON.
        POI_ID:	ID del lector si el pago se realiza a través de un comercio físico.Número de serie del lector (S/N)
        POI_WALLET_NAME:	Nombre de la billetera virtual desde la que se origina un pago digital. Permite identificar el origen de una operación cuando cobras con un código QR interoperable .
        POI_BANK_NAME:	Nombre de la entidad bancaria desde la que se origina un pago digital. Permite identificar el origen de una operación cuando cobras con un código QR interoperable .
        CARD_INITIAL_NUMBER:	Corresponde a los primeros dígitos de la tarjeta crédito o débito con la que se hizo la compra.
        OPERATION_TAGS:	Son las etiquetas para categorizar y/o segmentar diferentes aspectos de la transacción, como por ejemplo los canales usados para hacer un pago. Se identifican como:

-Pago vía WhatsApp (WHATSAPP_PAY): Esta etiqueta indica que el pago fue hecho a través de WhatsApp.
Nombre de quien hace el pago (PAYER_NAME*)	Nombre de quien hace un pago o una donación.
Tipo de identificación del pagador (PAYER_ID_TYPE*)	Tipo de identificación de quien hace un pago o una donación.
Número de identificación del pagador (PAYER_ID_NUMBER*)	Número de identificación de quien hace un pago o una donación.
Canal de venta (BUSINESS_UNIT)	Corresponde al canal por medio del cual se generó una venta. Los canales son Mercado Pago, Mercado Libre, Mercado Shops y Delivery.
Plataforma de cobro (SUB_UNIT)	Permite identificar el medio que se utilizó para cobrar una venta con Mercado Pago.
Código de producto SKU (PRODUCT_SKU)	Código con el que como vendedor podrás identificar tus productos.
Detalle de la venta (SALE_DETAIL)	Esta columna ofrece información detallada sobre los artículos vendidos en cada entrega, facilitando la conciliación y el control de tus ventas.


    Para Liberaciones:
    https://www.mercadopago.com.ar/developers/es/docs/subscriptions/additional-content/reports/released-money/report-fields
    DATE:	Fecha de liberación, bloqueo o desbloqueo, según corresponda.
    SOURCE_ID:	ID de operación en Mercado Pago (por ejemplo, el pago de una venta).
    EXTERNAL_REFERENCE:	Este dato ayuda a identificar una operación según su origen, el código puede ser:
                    - ID de la venta a través de la orden o el envío (si es una compra de carrito)
                    - ID propio provisto por el vendedor en caso de una integración externa
                    - ID generado por Coelsa, entidad que procesa el retiro hacia otra cuenta
                Es posible que este campo esté vacío para algunos casos como el pago de facturas o un envío de dinero, entre otros.
    RECORD_TYPE:
        initial_available_balance → Dinero disponible del período anterior.
        release → Dinero de un cargo que fue liberado.
        total → Valor líquido total.
        total → Es el dinero que tienes disponible en tu cuenta. Se calcula como la diferencia entre el monto acreditado total y el monto debitado total.
        available_balance → Saldo previo y posterior a un retiro de dinero, que explica el balance de la cuenta.
    DESCRIPTION:	Posibles valores que puede tomar el campo:
            Para dinero liquidado release: Pago (payment), Percepción General Impuesto a los IIBB de CABA (tax_payment_ibcf), Anulación Percepción Impuesto a los IIBB de CABA (tax_payment_ibcf_cancel), Percepción sujeto excedido Régimen Simplificado 2% (tax_payment_ibex), Percepción Impuesto a los IIBB de Bs As (tax_payment_iibb), Anulación de Percepción Impuesto a los IIBB de Bs As (tax_payment_iibb_cancel), Tarifa de envío (shipping), Devolución de dinero (shipping_cancel), Retención de impuesto (tax_withdholding), Retención de impuesto cancelada (tax_withdholding_cancel), Contracargo (chargeback), fee_release_in_advance, Rendimientos positivos (asset_management_gain), Rendimientos negativos (asset_management_loss)<\br>
            Para saldo preivo a un retiro available_balance: el campo mostrará el prefijo pre o pos para indicar el saldo previo o posterior a un retiro, según corresponda, seguido del tipo de operación, en este caso, un retiro de dinero (payout) y finalmente, el número de identificación de la operación o ID Source.
            Prefijo + nombre de operación + número de la operación.
            Definiciones a tener en cuenta:
                contracargo chargeback: aparece cuando se inicia o resuelve un contracargo asociado al pago al que hace referencia.
                Reclamo dispute: aparece cuando se inicia o resuelve una mediación o reclamo sobre el pago al que hace referencia. Puede ocurrir antes o después de que el pago se haya liberado como dinero disponible e incluso retirado de la cuenta.
                Comisión por devolución de envío shipping_return: aparece cuando se bloquea o desbloquea un pago realizado por devolución express.
                Pago payment: pago que se libera en alguno de los canales en los que opera el cliente.
                Devolución de dinero refund: devolución asociada al pago al que hace referencia.
                Percepción General Impuesto a los IIBB de CABA tax_payment_ibcf: percepción de ingresos brutos en Capital Federal, se calcula una vez por mes de acuerdo a las operaciones transaccionadas. Para conciliar por operación, ver el detalle en los Informes de Facturas en MyML.
                Anulación Percepción Impuesto a los IIBB de CABA tax_payment_ibcf_cancel: cancelación del impuesto de percepción de ingresos brutos en Capital Federal.
                Percepción sujeto excedido Régimen Simplificado 2% tax_payment_ibex: percepción de ingresos brutos por sujeto excedido de régimen simplificado, se calcula una vez por mes de acuerdo a las operaciones transaccionadas. Para conciliar por operación, ver el detalle en los Informes de Facturas en MyML.
                Percepción Impuesto a los IIBB de Bs As tax_payment_iibb: percepción de ingresos brutos en provincia de Buenos Aires, se calcula una vez por mes de acuerdo a las operaciones transaccionadas. Para conciliar por operación, ver el detalle en los Informes de Facturas en MyML.
                Anulación de Percepción Impuesto a los IIBB de Bs As tax_payment_iibb_cancel: cancelación del impuesto de percepción de ingresos brutos.
                Percepción de impuesto a los IIBB tax_payment_iibb_cre_[jurisdicción]: percepción de impuesto a los IIBB - Mercado Crédito, en donde [jurisdicción] se reemplaza por el nombre de la provincia donde se te genera el impuesto.
                Ejemplo 1: Percepción Impuesto a los IIBB Misiones - Mercado Crédito (tax_payment_iibb_cre_misiones)
                Ejemplo 2: Percepción Impuesto a los IIBB San Luis - Mercado (tax_payment_iibb_cre_san_luis)
                Para conciliar por operación, ver el detalle en los Informes de Facturas en MyML.

                Percepción de impuesto a los IIBB y juristidiccón tax_iibb_[jurisdicción]: percepción de impuesto a los IIBB, en donde [jurisdicción] se reemplaza por el nombre de la provincia donde se te genera el impuesto.
                Ejemplo 1: tax_iibb_misiones
                Ejemplo 2: tax_iibb_san_luis
                Para conciliar por operación, ver el detalle en los Informes de Facturas en MyML

                Percepción Impuesto al Valor Agregado Régimen General tax_iva: percepción de Impuesto al Valor Agregado Régimen General.
                percepción de Impuesto al Valor Agregado Régimen General - Mercado Crédito. tax_iva_cre:
                Impuesto sobre Créditos y Débitos que rige en Argentina tax_credit_debit: impuesto sobre Créditos y Débitos que rige en Argentina desde el 1 de agosto de 2021 para personas jurídicas. Este impuesto alcanza a todas las transacciones realizadas con terceros, depósitos y extracciones en efectivo. Ver más detalle sobre este impuesto.
                Retención de impuesto cancelada tax_withdholding_cancel: la cancelación de la retención tax_withdholding.
                Retención de impuesto tax_withdholding: el cobro de retenciones que no se pudieron ejecutar transaccionales al pago asociado. En Argentina son únicamente retenciones de Ingresos Brutos (las percepciones se debitan como otra operación). En Uruguay son retenciones de IVA. En Colombia son retenciones de IVA, ICA y Fuente según aplique el caso.
                Impuesto sobre los Créditos y Débitos en pagos tax_withholding_payer: Impuesto sobre los Créditos y Débitos en pagos.
                Impuesto sobre los Créditos y Débitos en cobros tax_withholding_collector: impuesto sobre los Créditos y Débitos en cobros.
                Impuesto sobre los Créditos y Débitos en retiros tax_withholding_payout: impuesto sobre los Créditos y Débitos en retiros.
                Impuesto sobre los Créditos y Débitos en envíos tax_withholding_shipping: impuesto sobre los Créditos y Débitos en envíos.
                Tarifa de envío shipping: comisión de shipping para las compras de carrito que no se incluye en cada uno de los pagos del carrito.
                Devolución de dinero / Tarifa de envío shipping_cancel: cancelación de la comisión de shipping para las compras de carrito que no se incluye en cada uno de los pagos del carrito.
                Pago de comisiones / Adelanto de dinero fee-release_in_advance: comisión por adelanto.
                Rendimientos positivos asset_management_gain: rendimiento positivo generado por la variación del valor de cuotapartes suscritas en el fondo común de inversión.
                Rendimientos negativos asset_management_loss: rendimiento negativo generado por la variación del valor de cuotapartes suscritas en el fondo común de inversión.
                Restricción por comportamiento fraudulento restriction: ocurre cuando se te aplica una restricción por comportamiento fraudulento.
                Débito de la cuota de un préstamo credit_payment: aparece cuando se cobra la cuota de un préstamo otorgado.
                Extracción de efectivo payout: extracción en efectivo de dinero disponible en Mercado Pago.
                Embargo dinero invertido reserve_for_embargo_invested: embargo de tu dinero invertido. Este valor aparece cuando hay una reserva de dinero en fondos de inversión.
                Dinero retenido de envío por devolución de venta en Mercado Libre reserve_for_bpp_shipping_return: reserva para devoluciones.
                Dinero retenido por deuda reserve_for_debt_payment: retenido para cobro de deuda.
                Dinero retenido para reembolso reserve_for_refund: retenido para devoluciones.
                Dinero retenido por contracargo de cuenta vinculada reserve_for_cbk_cross_recovery: retenido por contracargo de cuenta vinculada.
                Consumos pendientes de confirmación reserve_for_payment: consumos pendientes de confirmación.

        NET_CREDIT_AMOUNT:	Acreditado al monto disponible.
        NET_DEBIT_AMOUNT:	Debitado al monto disponible.
        SELLER_AMOUNT:	Monto recibido por compras por split.
        GROSS_AMOUNT:	Monto de la operación bruto.
        METADATA:	Datos extras como por ejemplo el ID de las devoluciones parciales o datos provistos por el vendedor en caso de tener una integración externa.
        MP_FEE_AMOUNT	Pago Comisión de Mercado Pago y/o Mercado Libre. Incluye IVA.
        FINANCING_FEE_AMOUNT:	Costo por ofrecer cuotas sin interés.
        SHIPPING_FEE_AMOUNT:	Costo de envío.
        TAXES_AMOUNT:	Impuestos cobrados por retenciones de Ingresos Brutos, IVA, Ganancias; e impuestos sobre los Créditos y Débitos, entre otros. Ver más detalle sobre retenciones y percepciones.Ver más detalle sobre retenciones y percepciones por retenciones de Ingresos Brutos.
        COUPON_AMOUNT:	Monto del cupón de descuento. Solo se descuenta del monto bruto (GROSS_AMOUNT) si está provisto por el vendedor.
        INSTALLMENTS:	Cantidad de cuotas en las que se realizó la operación.
        PAYMENT METHOD:	Medios de pago disponibles según el país con el que operes en Mercado Pago.
        TAX_DETAIL:     Descripción del impuesto retenido por operación en el impuesto cobrado por retenciones IIBB TAXES_AMOUNT. Puede tomar los siguientes valores según la jurisdicción:
                        cordoba
                        corrientes
                        mendoza
                        la_pampa
                        santa_fe
                        tucuman
                        entre_rios
                        catamarca
                        neuquen
                        santiago_del_estero
                        rio_negro
                        jujuy
                        También se puede visualizar devolución_percepción_gral cuando la operación es la devolución de este impuesto.
                        También se puede visualizar devolución percepción general cuando la operación es la devolución de este impuesto.
        TAX_AMOUNT_TELCO:	Es el valor del impuesto a las empresas de telecomunicaciones que se descuenta del valor bruto.
        TRANSACTION_APPROVAL_DATE:	Fecha de aprobación de la operación.
        POS_ID:	ID de caja si el pago se realiza a través de un comercio físico.
        POS_NAME:	Nombre de caja para el pago realizado a través de un comercio físico.
        EXTERNAL_POS_ID:	ID de caja definido por el usuario para el pago realizado a través de un comercio físico.
        STORE_ID:	ID de sucursal si el pago se realiza a través de un comercio físico.
        STORE_NAME:	Nombre de sucursal para el pago realizado a través de un comercio físico.
        EXTERNAL_STORE_ID:	ID de sucursal definido por el usuario para el pago realizado a través de un comercio físico.
        ORDER_ID:	Orden de compra.
        SHIPPING_ID:	Identificador de envío.
        SHIPMENT_MODE:	Modalidad de envío.
        PACK_ID:	Identificador del paquete en el carrito.
        TAXES_DISAGGREGATED:	Impuestos desagregados en formato JSON.
        EFFECTIVE_COUPON_AMOUNT:	Costo por ofrecer descuento.
        POI_ID:	ID del lector si el pago se realiza a través de un comercio físico. (Numero de seria)
        CARD_INITIAL_NUMBER:	Corresponde a los primeros dígitos de la tarjeta crédito o débito con la que se hizo la compra.
        OPERATION_TAGS:	Son las etiquetas para categorizar y/o segmentar diferentes aspectos de la transacción, como por ejemplo los canales usados para hacer un pago. Se identifican como:

        WHATSAPP_PAY:: Esta etiqueta indica que el pago fue hecho a través de whatsApp.
        ITEM_ID:	Identificador del producto vendido.
        PAYER_NAME*:	Nombre de quien hace un pago o una donación.
        PAYER_ID_TYPE*:	Tipo de identificación de quien hace un pago o una donación.
        PAYER_ID_NUMBER*:	Número de identificación de quien hace un pago o una donación.
        BUSINESS_UNIT:	Corresponde al canal por medio del cual se generó una venta. Los canales son Mercado Pago, Mercado Libre, Mercado Shops y Delivery.
        SUB_UNIT:	Permite identificar el medio que se utilizó para cobrar una venta con Mercado Pago.
        BALANCE_AMOUNT:	En esta columna se visualiza el saldo que queda en una cuenta luego de que se ejecuta una operación que afecta el valor total.
        PAYOUT_BANK_ACCOUNT_NUMBER:	Aquí se muestra el número completo de la cuenta a la que se envió dinero desde Mercado Pago.
        RODUCT_SKU:	Código con el que como vendedor podrás identificar tus productos.
        SALE_DETAIL:	Esta columna ofrece información detallada sobre los artículos vendidos en cada entrega, facilitando la conciliación y el control de tus ventas.



    *
    */

    public MercadoPagoReportConfigurationColumn() {
    }
    public MercadoPagoReportConfigurationColumn(String key) {
        this.setKey(key);
    }
    private String key;

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MercadoPagoReportConfigurationColumn that = (MercadoPagoReportConfigurationColumn) o;

        return Objects.equals(key, that.key);
    }

    @Override
    public int hashCode() {
        return key != null ? key.hashCode() : 0;
    }

    @Override
    public String toString() {
        return "MercadoPagoReportConfigurationColumn [" +
                "key=" + key +
                ']';
    }


    static public MercadoPagoReportConfigurationColumn[] getAllTransactionColumnsV1() {
        String []keys={"EXTERNAL_REFERENCE","SOURCE_ID","USER_ID","PAYMENT_METHOD_TYPE","PAYMENT_METHOD",
                        "SITE","TRANSACTION_TYPE","TRANSACTION_AMOUNT","TRANSACTION_CURRENCY",
                        "TRANSACTION_DATE","FEE_AMOUNT","SETTLEMENT_NET_AMOUNT","SETTLEMENT_CURRENCY",
                        "SETTLEMENT_DATE","REAL_AMOUNT","COUPON_AMOUNT","METADATA",
                        "MKP_FEE_AMOUNT","FINANCING_FEE_AMOUNT","SHIPPING_FEE_AMOUNT","TAXES_AMOUNT",
                        "INSTALLMENTS","TAX_DETAIL","TAX_AMOUNT_TELCO","POS_ID","STORE_ID","STORE_NAME",
                        "EXTERNAL_POS_ID","POS_NAME","EXTERNAL_STORE_ID","FEE_PREVISION"};
        return getColumns(keys);
    }
    static public  MercadoPagoReportConfigurationColumn[] getAllTransactionColumns() {
        String []keys={"EXTERNAL_REFERENCE","SOURCE_ID","USER_ID","PAYMENT_METHOD_TYPE","PAYMENT_METHOD",
                "SITE","TRANSACTION_TYPE","TRANSACTION_AMOUNT","TRANSACTION_CURRENCY",
                "TRANSACTION_DATE","FEE_AMOUNT","SETTLEMENT_NET_AMOUNT","SETTLEMENT_CURRENCY",
                "SETTLEMENT_DATE","REAL_AMOUNT","COUPON_AMOUNT","METADATA",
                "MKP_FEE_AMOUNT","FINANCING_FEE_AMOUNT","SHIPPING_FEE_AMOUNT","TAXES_AMOUNT",
                "INSTALLMENTS","TAX_DETAIL","TAX_AMOUNT_TELCO","POS_ID","STORE_ID","STORE_NAME",
                "EXTERNAL_POS_ID","POS_NAME","EXTERNAL_STORE_ID","FEE_PREVISION",
                "SELLER_AMOUNT","ORDER_ID","SHIPPING_ID","SHIPMENT_MODE","PACK_ID","POI_ID","POI_WALLET_NAME","POI_BANK_NAME","CARD_INITIAL_NUMBER","OPERATION_TAGS",
                "TAXES_DISAGGREGATED"
        };
        return getColumns(keys);
    }
    static public  MercadoPagoReportConfigurationColumn[] getColumns(String ...colums) {
        MercadoPagoReportConfigurationColumn[] result = new MercadoPagoReportConfigurationColumn[colums.length];
        int i=0;
        for (String col:colums) {
            result[i++] = new MercadoPagoReportConfigurationColumn(col);
        }
        return result;
    }

}
