package ar.com.sdd.mercadopago.entity.payment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Mercado Pago SDK
 * Additional Info class
 * <p>
 * Created by Eduardo Paoletta on 12/2/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AdditionalInfo {

    private ArrayList<Item> items = null;
    private AdditionalInfoPayer payer = null;
    private Shipments shipments = null;

    public AdditionalInfo appendItem(Item item) {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        items.add(item);
        return this;
    }

    public ArrayList<Item> getItems() {
        return items;
    }

    public AdditionalInfo setItems(ArrayList<Item> items) {
        this.items = items;
        return this;
    }

    public AdditionalInfoPayer getPayer() {
        return payer;
    }

    public AdditionalInfo setPayer(AdditionalInfoPayer payer) {
        this.payer = payer;
        return this;
    }

    public Shipments getShipments() {
        return shipments;
    }

    public AdditionalInfo setShipments(Shipments shipments) {
        this.shipments = shipments;
        return this;
    }

    @Override
    public String toString() {
        return "AdditionalInfo ["
                + ((items != null) ? "items=" + Arrays.toString(items.toArray()) + ", " : "")
                + ((payer != null) ? "payer=" + payer + ", " : "")
                + ((shipments != null) ? "shipments=" + shipments : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AdditionalInfo that = (AdditionalInfo) o;

        if (items != null ? !items.equals(that.items) : that.items != null) return false;
        if (payer != null ? !payer.equals(that.payer) : that.payer != null) return false;
        return shipments != null ? shipments.equals(that.shipments) : that.shipments == null;
    }

    @Override
    public int hashCode() {
        int result = items != null ? items.hashCode() : 0;
        result = 31 * result + (payer != null ? payer.hashCode() : 0);
        result = 31 * result + (shipments != null ? shipments.hashCode() : 0);
        return result;
    }
}
