
package ar.com.sdd.mercadopago.entity.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class User {

    @JsonProperty("id")
    private Long id;
    @JsonProperty("nickname")
    private String nickname;
    @JsonProperty("registration_date")
    private String registrationDate;
    @JsonProperty("first_name")
    private String firstName;
    @JsonProperty("last_name")
    private String lastName;
    @JsonProperty("gender")
    private String gender;
    @JsonProperty("country_id")
    private String countryId;
    @JsonProperty("email")
    private String email;
    @JsonProperty("identification")
    private Identification identification;
    @JsonProperty("internal_tags")
    private List<String> internalTags = null;
    @JsonProperty("address")
    private Address address;
    @JsonProperty("phone")
    private Phone phone;
    @JsonProperty("alternative_phone")
    private AlternativePhone alternativePhone;
    @JsonProperty("user_type")
    private String userType;
    @JsonProperty("tags")
    private List<String> tags = null;
    @JsonProperty("logo")
    private Object logo;
    @JsonProperty("points")
    private Long points;
    @JsonProperty("site_id")
    private String siteId;
    @JsonProperty("permalink")
    private String permalink;
    @JsonProperty("shipping_modes")
    private List<String> shippingModes = null;
    @JsonProperty("seller_experience")
    private String sellerExperience;
    @JsonProperty("bill_data")
    private BillData billData;
    @JsonProperty("seller_reputation")
    private SellerReputation sellerReputation;
    @JsonProperty("buyer_reputation")
    private BuyerReputation buyerReputation;
    @JsonProperty("status")
    private Status status;
    @JsonProperty("secure_email")
    private String secureEmail;
    @JsonProperty("company")
    private Company company;
    @JsonProperty("credit")
    private Credit credit;
    @JsonProperty("context")
    private Context context;
    @JsonProperty("registration_identifiers")
    private Object[] registrationIdentifiers;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("id")
    public Long getId() {
        return id;
    }

    @JsonProperty("id")
    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty("nickname")
    public String getNickname() {
        return nickname;
    }

    @JsonProperty("nickname")
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @JsonProperty("registration_date")
    public String getRegistrationDate() {
        return registrationDate;
    }

    @JsonProperty("registration_date")
    public void setRegistrationDate(String registrationDate) {
        this.registrationDate = registrationDate;
    }

    @JsonProperty("first_name")
    public String getFirstName() {
        return firstName;
    }

    @JsonProperty("first_name")
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @JsonProperty("last_name")
    public String getLastName() {
        return lastName;
    }

    @JsonProperty("last_name")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty("gender")
    public String getGender() {
        return gender;
    }

    @JsonProperty("gender")
    public void setGender(String gender) {
        this.gender = gender;
    }

    @JsonProperty("country_id")
    public String getCountryId() {
        return countryId;
    }

    @JsonProperty("country_id")
    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    @JsonProperty("email")
    public String getEmail() {
        return email;
    }

    @JsonProperty("email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty("identification")
    public Identification getIdentification() {
        return identification;
    }

    @JsonProperty("identification")
    public void setIdentification(Identification identification) {
        this.identification = identification;
    }

    @JsonProperty("internal_tags")
    public List<String> getInternalTags() {
        return internalTags;
    }

    @JsonProperty("internal_tags")
    public void setInternalTags(List<String> internalTags) {
        this.internalTags = internalTags;
    }

    @JsonProperty("address")
    public Address getAddress() {
        return address;
    }

    @JsonProperty("address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty("phone")
    public Phone getPhone() {
        return phone;
    }

    @JsonProperty("phone")
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    @JsonProperty("alternative_phone")
    public AlternativePhone getAlternativePhone() {
        return alternativePhone;
    }

    @JsonProperty("alternative_phone")
    public void setAlternativePhone(AlternativePhone alternativePhone) {
        this.alternativePhone = alternativePhone;
    }

    @JsonProperty("user_type")
    public String getUserType() {
        return userType;
    }

    @JsonProperty("user_type")
    public void setUserType(String userType) {
        this.userType = userType;
    }

    @JsonProperty("tags")
    public List<String> getTags() {
        return tags;
    }

    @JsonProperty("tags")
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonProperty("logo")
    public Object getLogo() {
        return logo;
    }

    @JsonProperty("logo")
    public void setLogo(Object logo) {
        this.logo = logo;
    }

    @JsonProperty("points")
    public Long getPoints() {
        return points;
    }

    @JsonProperty("points")
    public void setPoints(Long points) {
        this.points = points;
    }

    @JsonProperty("site_id")
    public String getSiteId() {
        return siteId;
    }

    @JsonProperty("site_id")
    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    @JsonProperty("permalink")
    public String getPermalink() {
        return permalink;
    }

    @JsonProperty("permalink")
    public void setPermalink(String permalink) {
        this.permalink = permalink;
    }

    @JsonProperty("shipping_modes")
    public List<String> getShippingModes() {
        return shippingModes;
    }

    @JsonProperty("shipping_modes")
    public void setShippingModes(List<String> shippingModes) {
        this.shippingModes = shippingModes;
    }

    @JsonProperty("seller_experience")
    public String getSellerExperience() {
        return sellerExperience;
    }

    @JsonProperty("seller_experience")
    public void setSellerExperience(String sellerExperience) {
        this.sellerExperience = sellerExperience;
    }

    @JsonProperty("bill_data")
    public BillData getBillData() {
        return billData;
    }

    @JsonProperty("bill_data")
    public void setBillData(BillData billData) {
        this.billData = billData;
    }

    @JsonProperty("seller_reputation")
    public SellerReputation getSellerReputation() {
        return sellerReputation;
    }

    @JsonProperty("seller_reputation")
    public void setSellerReputation(SellerReputation sellerReputation) {
        this.sellerReputation = sellerReputation;
    }

    @JsonProperty("buyer_reputation")
    public BuyerReputation getBuyerReputation() {
        return buyerReputation;
    }

    @JsonProperty("buyer_reputation")
    public void setBuyerReputation(BuyerReputation buyerReputation) {
        this.buyerReputation = buyerReputation;
    }

    @JsonProperty("status")
    public Status getStatus() {
        return status;
    }

    @JsonProperty("status")
    public void setStatus(Status status) {
        this.status = status;
    }

    @JsonProperty("secure_email")
    public String getSecureEmail() {
        return secureEmail;
    }

    @JsonProperty("secure_email")
    public void setSecureEmail(String secureEmail) {
        this.secureEmail = secureEmail;
    }

    @JsonProperty("company")
    public Company getCompany() {
        return company;
    }

    @JsonProperty("company")
    public void setCompany(Company company) {
        this.company = company;
    }

    @JsonProperty("credit")
    public Credit getCredit() {
        return credit;
    }

    @JsonProperty("credit")
    public void setCredit(Credit credit) {
        this.credit = credit;
    }

    @JsonProperty("context")
    public Context getContext() {
        return context;
    }

    @JsonProperty("context")
    public void setContext(Context context) {
        this.context = context;
    }

    @JsonProperty("registration_identifiers")
    public Object[] getRegistrationIdentifiers() {
        return registrationIdentifiers;
    }

    @JsonProperty("registration_identifiers")
    public void setRegistrationIdentifiers(Object[] registrationIdentifiers) {
        this.registrationIdentifiers = registrationIdentifiers;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "User ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((nickname != null) ? "nickname=" + nickname + ", " : "")
                + ((registrationDate != null) ? "registrationDate=" + registrationDate + ", " : "")
                + ((firstName != null) ? "firstName=" + firstName + ", " : "")
                + ((lastName != null) ? "lastName=" + lastName + ", " : "")
                + ((gender != null) ? "gender=" + gender + ", " : "")
                + ((countryId != null) ? "countryId=" + countryId + ", " : "")
                + ((email != null) ? "email=" + email + ", " : "")
                + ((identification != null) ? "identification=" + identification + ", " : "")
                + ((internalTags != null) ? "internalTags=" + Arrays.toString(internalTags.toArray()) + ", " : "")
                + ((address != null) ? "address=" + address + ", " : "")
                + ((phone != null) ? "phone=" + phone + ", " : "")
                + ((alternativePhone != null) ? "alternativePhone=" + alternativePhone + ", " : "")
                + ((userType != null) ? "userType=" + userType + ", " : "")
                + ((tags != null) ? "tags=" + Arrays.toString(tags.toArray()) + ", " : "")
                + ((logo != null) ? "logo=" + logo + ", " : "")
                + ((points != null) ? "points=" + points + ", " : "")
                + ((siteId != null) ? "siteId=" + siteId + ", " : "")
                + ((permalink != null) ? "permalink=" + permalink + ", " : "")
                + ((shippingModes != null) ? "shippingModes=" + Arrays.toString(shippingModes.toArray()) + ", " : "")
                + ((sellerExperience != null) ? "sellerExperience=" + sellerExperience + ", " : "")
                + ((billData != null) ? "billData=" + billData + ", " : "")
                + ((sellerReputation != null) ? "sellerReputation=" + sellerReputation + ", " : "")
                + ((buyerReputation != null) ? "buyerReputation=" + buyerReputation + ", " : "")
                + ((status != null) ? "status=" + status + ", " : "")
                + ((secureEmail != null) ? "secureEmail=" + secureEmail + ", " : "")
                + ((company != null) ? "company=" + company + ", " : "")
                + ((credit != null) ? "credit=" + credit + ", " : "")
                + ((context != null) ? "context=" + context + ", " : "")
                + ((registrationIdentifiers != null) ? "registrationIdentifiers=" + Arrays.toString(registrationIdentifiers) + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
