/*
 * Decompiled with CFR 0.152.
 */
package ar.com.sdd.mercadopago.core;

import ar.com.sdd.commons.rest.core.RestConnector;
import ar.com.sdd.commons.rest.core.RestConnectorEnvironment;
import ar.com.sdd.commons.rest.core.RestConnectorException;
import ar.com.sdd.commons.rest.core.RestSecurityManager;
import ar.com.sdd.commons.rest.model.TokenOAuth2;
import ar.com.sdd.commons.rest.util.QueryBuilder;
import ar.com.sdd.commons.util.StringUtil;
import ar.com.sdd.mercadopago.entity.MPError;
import ar.com.sdd.mercadopago.entity.MPErrorReport;
import ar.com.sdd.mercadopago.entity.MPErrorResponse;
import ar.com.sdd.mercadopago.entity.MPPaging;
import ar.com.sdd.mercadopago.entity.MPTokenOAuth2;
import ar.com.sdd.mercadopago.entity.MerchantOrder;
import ar.com.sdd.mercadopago.entity.Payment;
import ar.com.sdd.mercadopago.entity.Preference;
import ar.com.sdd.mercadopago.entity.account.MercadoPagoReportConfiguration;
import ar.com.sdd.mercadopago.entity.account.MercadoPagoReportResponse;
import ar.com.sdd.mercadopago.entity.account.MercadoPagotReportRequest;
import ar.com.sdd.mercadopago.entity.user.User;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MercadoPagoConnector
implements RestSecurityManager {
    private static final Logger log = LogManager.getLogger(MercadoPagoConnector.class);
    private final RestConnector connector;
    private final String mpBaseUrl;
    private final String accessToken;

    public MercadoPagoConnector(String accessToken) {
        this(null, accessToken);
    }

    public MercadoPagoConnector(String mpBaseUrl, String accessToken) {
        this.mpBaseUrl = mpBaseUrl != null ? mpBaseUrl : "https://api.mercadopago.com";
        this.accessToken = accessToken;
        RestConnectorEnvironment environment = new RestConnectorEnvironment(this.mpBaseUrl);
        this.connector = new RestConnector(environment, (RestSecurityManager)this);
    }

    public Preference savePreference(Preference request) throws RestConnectorException {
        log.debug("[savePreference] Request POST preferencia [{}]", (Object)request);
        Preference response = (Preference)this.connector.genericPost((Object)request, Preference.class, MPError.class, "/checkout/preferences?access_token=" + this.accessToken);
        log.debug("[savePreference] Response POST de la preferencia [{}]", (Object)response);
        return response;
    }

    public Preference updatePreference(Preference request) throws RestConnectorException {
        log.debug("[updatePreference] Request PUT preferencia [{}]", (Object)request);
        String id = request.getId();
        Preference response = (Preference)this.connector.genericPut((Object)request, Preference.class, MPErrorResponse.class, "/checkout/preferences/" + id + "?access_token=" + this.accessToken);
        log.debug("[updatePreference] Response PUT de la preferencia [{}]", (Object)response);
        return response;
    }

    public MPPaging<Payment> searchPayment(String externalReference) throws RestConnectorException {
        log.debug("[searchPayment] Request con externalReference [{}]", (Object)externalReference);
        MPPaging response = (MPPaging)this.connector.genericGet(null, MPPaging.MPPagingPayment.class, MPError.class, "/v1/payments/search?external_reference=" + externalReference + "&access_token=" + this.accessToken);
        log.debug("[searchPayment] Response con externalReference [{}],  [{}]", (Object)externalReference, (Object)response);
        return response;
    }

    public MPPaging<Payment> searchPaymentById(String id) throws RestConnectorException {
        log.debug("[searchPayment] Request con id [{}]", (Object)id);
        MPPaging response = (MPPaging)this.connector.genericGet(null, MPPaging.MPPagingPayment.class, MPError.class, "/v1/payments/" + id + "&access_token=" + this.accessToken);
        log.debug("[searchPayment] Response con id [{}],  [{}]", (Object)id, (Object)response);
        return response;
    }

    public MPPaging<MerchantOrder> searchMerchantOrderById(String id) throws RestConnectorException {
        log.debug("[searchMerchantOrder] Request con id [{}]", (Object)id);
        MPPaging response = (MPPaging)this.connector.genericGet(null, MPPaging.MPPagingMerchantOrder.class, MPError.class, "/merchant_orders/" + id + "&access_token=" + this.accessToken);
        log.debug("[searchMerchantOrder] Response con id [{}],  [{}]", (Object)id, (Object)response);
        return response;
    }

    public TokenOAuth2 getToken(String clientId, String clientSecret) throws RestConnectorException {
        Form form = new Form();
        form.param("client_id", clientId);
        form.param("client_secret", clientSecret);
        form.param("grant_type", "client_credentials");
        log.debug("[getToken] Por recuperar token con clientId [{}], clientSecret [{}]", (Object)clientId, (Object)clientSecret);
        RestConnectorEnvironment environment = new RestConnectorEnvironment();
        environment.baseUrl = this.mpBaseUrl;
        RestConnector connector = new RestConnector(environment, null);
        TokenOAuth2 tokenOAuth2Response = (TokenOAuth2)connector.genericPost((Object)form, TokenOAuth2.class, "/oauth/token", "application/json", "application/x-www-form-urlencoded");
        log.debug("[getToken] Token recuperado [{}]", (Object)tokenOAuth2Response);
        return tokenOAuth2Response;
    }

    public MPTokenOAuth2 getAuthorizationCodeToken(String environment, String clientId, String clientSecret, String applicationAccessToken, String mercadoPagoId, String redirectUri, String refreshToken) throws RestConnectorException {
        log.debug("[getAuthorizationCodeToken] Entrando en getAuthorizationCodeToken con environment [{}], clientId [{}], clientSecret [{}], applicationAccessToken [{}], mercadoPagoId (code) [{}], redirectUri [{}], refreshToken [{}]", (Object)environment, (Object)clientId, (Object)clientSecret, (Object)applicationAccessToken, (Object)mercadoPagoId, (Object)redirectUri, (Object)refreshToken);
        boolean isSandbox = StringUtils.equalsIgnoreCase((CharSequence)environment, (CharSequence)"sandbox");
        Form form = new Form();
        if (isSandbox) {
            form.param("client_secret", applicationAccessToken);
            form.param("code", mercadoPagoId);
            form.param("redirect_uri", redirectUri);
            form.param("grant_type", "authorization_code");
        } else {
            form.param("client_id", clientId);
            form.param("client_secret", clientSecret);
            form.param("code", mercadoPagoId);
            form.param("redirect_uri", redirectUri);
            form.param("grant_type", "authorization_code");
        }
        if (StringUtils.isNotEmpty((CharSequence)refreshToken)) {
            form.param("refresh_token", refreshToken);
            form.param("grant_type", "authorization_code");
        }
        MultivaluedMap formMap = form.asMap();
        String formMapAsString = formMap.keySet().stream().map(key -> key + "=" + formMap.get(key)).collect(Collectors.joining(", ", "{", "}"));
        log.debug("[getAuthorizationCodeToken] Por recuperar token con isSandobx [{}], form [{}]", (Object)isSandbox, (Object)formMapAsString);
        MPTokenOAuth2 tokenOAuth2Response = (MPTokenOAuth2)this.connector.genericPost((Object)form, MPTokenOAuth2.class, MPErrorResponse.class, "/oauth/token", "application/json", "application/x-www-form-urlencoded");
        log.debug("[getAuthorizationCodeToken] Token recuperado [{}]", (Object)tokenOAuth2Response);
        return tokenOAuth2Response;
    }

    public User getUsersMe(String userAccessToken) throws RestConnectorException {
        log.debug("[getUsersMe] Por recuperar usuario con userAccessToken [{}]", (Object)userAccessToken);
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/users/me").add("access_token", userAccessToken);
        User user = (User)this.connector.genericGet(Void.class, User.class, MPErrorResponse.class, queryBuilder.build());
        log.debug("[getUsersMe] User recuperado [{}]", (Object)user);
        return user;
    }

    public Payment postPayments(Payment payment) throws RestConnectorException {
        log.debug("[postPayments] Por enviar el pago [{}]", (Object)payment);
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/v1/payments").add("access_token", this.accessToken);
        Payment paymentResponse = (Payment)this.connector.genericPost((Object)payment, Payment.class, MPErrorResponse.class, queryBuilder.build());
        log.debug("[postPayments] Payment devuelto [{}]", (Object)paymentResponse);
        return paymentResponse;
    }

    public MercadoPagoReportResponse postMercadoPagoReport(MercadoPagotReportRequest request, String reportType) throws RestConnectorException {
        log.debug("[postMercadoPagoReport] Request POST mercadoPago");
        MercadoPagoReportResponse response = (MercadoPagoReportResponse)this.connector.genericPost((Object)request, MercadoPagoReportResponse.class, "/v1/account/" + reportType + "?access_token=" + this.accessToken);
        log.debug("[postMercadoPagoReport] Response [{}]", (Object)response);
        return response;
    }

    public List<MercadoPagoReportResponse> getMercadoPagoReports(String reportType) throws RestConnectorException {
        log.debug("[getMercadoPagoReports] Request GET getMercadoPagoReports");
        MercadoPagoReportResponse[] responseArray = (MercadoPagoReportResponse[])this.connector.genericGet(null, MercadoPagoReportResponse[].class, "/v1/account/" + reportType + "/list?access_token=" + this.accessToken);
        List<MercadoPagoReportResponse> response = Arrays.asList(responseArray);
        log.debug("[getMercadoPagoReports] Request GET getMercadoPagoReports response [{}]", (Object)StringUtil.toDebugString(response));
        return response;
    }

    public String downloadMercadoPagoReport(String fileName, String reportType) throws RestConnectorException {
        log.debug("[downloadMercadoPagoReport] Request GET bank_report fileName [{}]", (Object)fileName);
        String response = (String)this.connector.genericGet(null, String.class, "/v1/account/" + reportType + "/" + fileName + "?access_token=" + this.accessToken);
        log.debug("[downloadMercadoPagoReport] Response con fileName [{}][{}]", (Object)fileName, (Object)response);
        return response;
    }

    public MercadoPagoReportConfiguration getMercadoPagoReportConfiguration(String reportType) throws RestConnectorException {
        log.debug("[getMercadoPagoReportConfiguration] Request para el reportType [{}]", (Object)reportType);
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/v1/account/" + reportType + "/config").add("access_token", this.accessToken);
        MercadoPagoReportConfiguration responseConfiguration = (MercadoPagoReportConfiguration)this.connector.genericGet(Void.class, MercadoPagoReportConfiguration.class, MPErrorReport.class, queryBuilder.build());
        log.debug("[getMercadoPagoReportConfiguration] Response [{}]", (Object)responseConfiguration);
        return responseConfiguration;
    }

    public MercadoPagoReportConfiguration postMercadoPagoReportConfiguration(MercadoPagoReportConfiguration requestConfiguration, String reportType) throws RestConnectorException {
        log.debug("[postMercadoPagoReportConfiguration] Request para el reportType [{}], con configuracion [{}]", (Object)reportType, (Object)requestConfiguration);
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/v1/account/" + reportType + "/config").add("access_token", this.accessToken);
        MercadoPagoReportConfiguration responseConfiguration = (MercadoPagoReportConfiguration)this.connector.genericPost((Object)requestConfiguration, MercadoPagoReportConfiguration.class, MPErrorReport.class, queryBuilder.build());
        log.debug("[postMercadoPagoReportConfiguration] Response [{}]", (Object)responseConfiguration);
        return responseConfiguration;
    }

    public MercadoPagoReportConfiguration putMercadoPagoReportConfiguration(MercadoPagoReportConfiguration requestConfiguration, String reportType) throws RestConnectorException {
        log.debug("[putMercadoPagoReportConfiguration] Request para el reportType [{}], con configuracion [{}]", (Object)reportType, (Object)requestConfiguration);
        QueryBuilder queryBuilder = QueryBuilder.Builder().path("/v1/account/" + reportType + "/config").add("access_token", this.accessToken);
        MercadoPagoReportConfiguration responseConfiguration = (MercadoPagoReportConfiguration)this.connector.genericPut((Object)requestConfiguration, MercadoPagoReportConfiguration.class, MPErrorReport.class, queryBuilder.build());
        log.debug("[putMercadoPagoReportConfiguration] Response [{}]", (Object)responseConfiguration);
        return responseConfiguration;
    }

    public Invocation.Builder addHeaders(Invocation.Builder builder) throws RestConnectorException {
        if (StringUtils.isNotEmpty((CharSequence)this.accessToken)) {
            builder.header("Authorization", (Object)("Bearer " + this.accessToken));
        }
        return builder;
    }

    public boolean getDisableHTTPSErrors() {
        return false;
    }

    public boolean retryOnUnauthorized() {
        return false;
    }
}

