package ar.com.sdd.mercadopago.entity;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class FlexibleDateDeserializer extends StdDeserializer<Date> {
    private static final Logger log = LogManager.getLogger(FlexibleDateDeserializer.class);

    private static final List<String> DATE_FORMATS = Arrays.asList(
            "yyyy-MM-dd'T'HH:mm:ss.SSSZ",   // ISO 8601 with milliseconds and timezone
            "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", // ISO 8601 with milliseconds and timezone
            "yyyy-MM-dd'T'HH:mm:ssZ",       // ISO 8601 with timezone
            "yyyy-MM-dd'T'HH:mm:ss'Z'",     // ISO 8601 with timezone
            "yyyy-MM-dd HH:mm:ss",          // Common format
            "yyyy-MM-dd'T'HH:mm:ssXXX",     // ISO 8601 with timezone in XXX format
            "yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'", // Otro
            "yyyy-MM-dd"                    // Another common format
    );

    public FlexibleDateDeserializer() {
        this(null);
    }

    public FlexibleDateDeserializer(Class<?> vc) {
        super(vc);
    }

    @Override
    public Date deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String dateString = jsonParser.getText();
        for (String format : DATE_FORMATS) {
            try {
                return new SimpleDateFormat(format).parse(dateString);
            } catch (ParseException e) {
                // Try next format
            }
        }
        log.error("No pude deserializar la fecha: \"" + dateString + "\" con ningun formato registrado.");
        return null;
    }
}