package ar.com.sdd.mercadopago.entity.customer.card;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Card Payment Method class
 *
 * Created by Eduardo Paoletta on 12/15/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PaymentMethod {

    private String id = null;
    private String name = null;
    private String paymentTypeId = null;
    private String thumbnail = null;
    private String secureThumbnail = null;


    public String getId() {
        return id;
    }

    public PaymentMethod setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public PaymentMethod setName(String name) {
        this.name = name;
        return this;
    }

    public String getPaymentTypeId() {
        return paymentTypeId;
    }

    public PaymentMethod setPaymentTypeId(String paymentTypeId) {
        this.paymentTypeId = paymentTypeId;
        return this;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public PaymentMethod setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public String getSecureThumbnail() {
        return secureThumbnail;
    }

    public PaymentMethod setSecureThumbnail(String secureThumbnail) {
        this.secureThumbnail = secureThumbnail;
        return this;
    }

    @Override
    public String toString() {
        return "PaymentMethod ["
                + ((id != null) ? "id=" + id + ", " : "")
                + ((name != null) ? "name=" + name + ", " : "")
                + ((paymentTypeId != null) ? "paymentTypeId=" + paymentTypeId + ", " : "")
                + ((thumbnail != null) ? "thumbnail=" + thumbnail + ", " : "")
                + ((secureThumbnail != null) ? "secureThumbnail=" + secureThumbnail : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PaymentMethod that = (PaymentMethod) o;

        if (id != null ? !id.equals(that.id) : that.id != null) return false;
        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        if (paymentTypeId != null ? !paymentTypeId.equals(that.paymentTypeId) : that.paymentTypeId != null) return false;
        if (thumbnail != null ? !thumbnail.equals(that.thumbnail) : that.thumbnail != null) return false;
        return secureThumbnail != null ? secureThumbnail.equals(that.secureThumbnail) : that.secureThumbnail == null;
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (paymentTypeId != null ? paymentTypeId.hashCode() : 0);
        result = 31 * result + (thumbnail != null ? thumbnail.hashCode() : 0);
        result = 31 * result + (secureThumbnail != null ? secureThumbnail.hashCode() : 0);
        return result;
    }
}
