package ar.com.sdd.mercadopago.entity.preference;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

/**
 * Mercado Pago SDK
 * Preference Shipment AddressReceiver class
 * <p>
 * Created by Eduardo Paoletta on 12/12/16.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class AddressReceiver extends Address {

    private String floor = null;
    private String apartment = null;


    public void AddressReceiver(String zipCode, Integer streetNumber, String streetName, String floor, String apartment) {
        this.setZipCode(zipCode);
        this.setStreetName(streetName);
        this.setStreetNumber(streetNumber);
        this.setFloor(floor);
        this.setApartment(apartment);
    }


    @Override
    public AddressReceiver setZipCode(String zipCode) {
        return (AddressReceiver) super.setZipCode(zipCode);
    }

    @Override
    public AddressReceiver setStreetName(String streetName) {
        return (AddressReceiver) super.setStreetName(streetName);
    }

    @Override
    public AddressReceiver setStreetNumber(Integer streetNumber) {
        return (AddressReceiver) super.setStreetNumber(streetNumber);
    }

    public String getFloor() {
        return floor;
    }

    public AddressReceiver setFloor(String floor) {
        this.floor = floor;
        return this;
    }

    public String getApartment() {
        return apartment;
    }

    public AddressReceiver setApartment(String apartment) {
        this.apartment = apartment;
        return this;
    }

    @Override
    public String toString() {
        return "AddressReceiver ["
                + ((floor != null) ? "floor=" + floor + ", " : "")
                + ((apartment != null) ? "apartment=" + apartment : "")
                + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        AddressReceiver that = (AddressReceiver) o;

        if (floor != null ? !floor.equals(that.floor) : that.floor != null) return false;
        return apartment != null ? apartment.equals(that.apartment) : that.apartment == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (floor != null ? floor.hashCode() : 0);
        result = 31 * result + (apartment != null ? apartment.hashCode() : 0);
        return result;
    }
}
