package ar.com.sdd.mercadopago.entity.user;

import com.fasterxml.jackson.annotation.*;

import java.util.HashMap;
import java.util.Map;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Company {

    @JsonProperty("brand_name")
    private Object brandName;
    @JsonProperty("city_tax_id")
    private String cityTaxId;
    @JsonProperty("corporate_name")
    private String corporateName;
    @JsonProperty("identification")
    private String identification;
    @JsonProperty("state_tax_id")
    private String stateTaxId;
    @JsonProperty("cust_type_id")
    private String custTypeId;
    @JsonProperty("soft_descriptor")
    private Object softDescriptor;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<>();

    @JsonProperty("brand_name")
    public Object getBrandName() {
        return brandName;
    }

    @JsonProperty("brand_name")
    public void setBrandName(Object brandName) {
        this.brandName = brandName;
    }

    @JsonProperty("city_tax_id")
    public String getCityTaxId() {
        return cityTaxId;
    }

    @JsonProperty("city_tax_id")
    public void setCityTaxId(String cityTaxId) {
        this.cityTaxId = cityTaxId;
    }

    @JsonProperty("corporate_name")
    public String getCorporateName() {
        return corporateName;
    }

    @JsonProperty("corporate_name")
    public void setCorporateName(String corporateName) {
        this.corporateName = corporateName;
    }

    @JsonProperty("identification")
    public String getIdentification() {
        return identification;
    }

    @JsonProperty("identification")
    public void setIdentification(String identification) {
        this.identification = identification;
    }

    @JsonProperty("state_tax_id")
    public String getStateTaxId() {
        return stateTaxId;
    }

    @JsonProperty("state_tax_id")
    public void setStateTaxId(String stateTaxId) {
        this.stateTaxId = stateTaxId;
    }

    @JsonProperty("cust_type_id")
    public String getCustTypeId() {
        return custTypeId;
    }

    @JsonProperty("cust_type_id")
    public void setCustTypeId(String custTypeId) {
        this.custTypeId = custTypeId;
    }

    @JsonProperty("soft_descriptor")
    public Object getSoftDescriptor() {
        return softDescriptor;
    }

    @JsonProperty("soft_descriptor")
    public void setSoftDescriptor(Object softDescriptor) {
        this.softDescriptor = softDescriptor;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @Override
    public String toString() {
        return "Company ["
                + ((brandName != null) ? "brandName=" + brandName + ", " : "")
                + ((cityTaxId != null) ? "cityTaxId=" + cityTaxId + ", " : "")
                + ((corporateName != null) ? "corporateName=" + corporateName + ", " : "")
                + ((identification != null) ? "identification=" + identification + ", " : "")
                + ((stateTaxId != null) ? "stateTaxId=" + stateTaxId + ", " : "")
                + ((custTypeId != null) ? "custTypeId=" + custTypeId + ", " : "")
                + ((softDescriptor != null) ? "softDescriptor=" + softDescriptor + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
