
package ar.com.sdd.mercadopago.entity.user;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.*;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Credit {

    @JsonProperty("consumed")
    private Long consumed;
    @JsonProperty("credit_level_id")
    private String creditLevelId;
    @JsonProperty("rank")
    private String rank;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty("consumed")
    public Long getConsumed() {
        return consumed;
    }

    @JsonProperty("consumed")
    public void setConsumed(Long consumed) {
        this.consumed = consumed;
    }

    @JsonProperty("credit_level_id")
    public String getCreditLevelId() {
        return creditLevelId;
    }

    @JsonProperty("credit_level_id")
    public void setCreditLevelId(String creditLevelId) {
        this.creditLevelId = creditLevelId;
    }

    @JsonProperty("rank")
    public String getRank() {
        return rank;
    }

    @JsonProperty("rank")
    public void setRank(String rank) {
        this.rank = rank;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }


    @Override
    public String toString() {
        return "Credit ["
                + ((consumed != null) ? "consumed=" + consumed + ", " : "")
                + ((creditLevelId != null) ? "creditLevelId=" + creditLevelId + ", " : "")
                + ((rank != null) ? "rank=" + rank + ", " : "")
                + ((additionalProperties != null) ? "additionalProperties=" + additionalProperties : "")
                + "]";
    }
}
