package ar.com.sdd.mercadopago.entity.account;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class MercadoPagoReportConfiguration {

    private String fileNamePrefix;
    private Boolean showFeePrevision;
    private Boolean showChargebackCancel;
    private Boolean detailed;
    private Boolean scheduled;
    private Boolean couponDetailed;
    private Boolean shippingDetail;
    private Boolean refundDetailed;
    private Boolean extended;
    private Boolean includeWithdraw;
    private MercadoPagoReportConfigurationFrequency frequency;
    private String separator;
    private String sftpInfo;

    public String getFileNamePrefix() {
        return fileNamePrefix;
    }

    public void setFileNamePrefix(String fileNamePrefix) {
        this.fileNamePrefix = fileNamePrefix;
    }

    public Boolean getShowFeePrevision() {
        return showFeePrevision;
    }

    public void setShowFeePrevision(Boolean showFeePrevision) {
        this.showFeePrevision = showFeePrevision;
    }

    public Boolean getShowChargebackCancel() {
        return showChargebackCancel;
    }

    public void setShowChargebackCancel(Boolean showChargebackCancel) {
        this.showChargebackCancel = showChargebackCancel;
    }

    public Boolean getDetailed() {
        return detailed;
    }

    public void setDetailed(Boolean detailed) {
        this.detailed = detailed;
    }

    public Boolean getScheduled() {
        return scheduled;
    }

    public void setScheduled(Boolean scheduled) {
        this.scheduled = scheduled;
    }

    public Boolean getCouponDetailed() {
        return couponDetailed;
    }

    public void setCouponDetailed(Boolean couponDetailed) {
        this.couponDetailed = couponDetailed;
    }

    public Boolean getShippingDetail() {
        return shippingDetail;
    }

    public void setShippingDetail(Boolean shippingDetail) {
        this.shippingDetail = shippingDetail;
    }

    public Boolean getRefundDetailed() {
        return refundDetailed;
    }

    public void setRefundDetailed(Boolean refundDetailed) {
        this.refundDetailed = refundDetailed;
    }

    public Boolean getExtended() {
        return extended;
    }

    public void setExtended(Boolean extended) {
        this.extended = extended;
    }

    public MercadoPagoReportConfigurationFrequency getFrequency() {
        return frequency;
    }

    public void setFrequency(MercadoPagoReportConfigurationFrequency frequency) {
        this.frequency = frequency;
    }

    public String getSeparator() {
        return separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getSftpInfo() {
        return sftpInfo;
    }

    public void setSftpInfo(String sftpInfo) {
        this.sftpInfo = sftpInfo;
    }

    public Boolean getIncludeWithdraw() {
        return includeWithdraw;
    }

    public void setIncludeWithdraw(Boolean includeWithdraw) {
        this.includeWithdraw = includeWithdraw;
    }

    @Override
    public String toString() {
        return "MercadoPagoReportConfiguration ["
                + ((fileNamePrefix != null) ? "fileNamePrefix=" + fileNamePrefix + ", " : "")
                + ((showFeePrevision != null) ? "showFeePrevision=" + showFeePrevision + ", " : "")
                + ((showChargebackCancel != null) ? "showChargebackCancel=" + showChargebackCancel + ", " : "")
                + ((detailed != null) ? "detailed=" + detailed + ", " : "")
                + ((scheduled != null) ? "scheduled=" + scheduled + ", " : "")
                + ((couponDetailed != null) ? "couponDetailed=" + couponDetailed + ", " : "")
                + ((shippingDetail != null) ? "shippingDetail=" + shippingDetail + ", " : "")
                + ((refundDetailed != null) ? "refundDetailed=" + refundDetailed + ", " : "")
                + ((extended != null) ? "extended=" + extended + ", " : "")
                + ((includeWithdraw != null) ? "includeWithdraw=" + includeWithdraw + ", " : "")
                + ((frequency != null) ? "frequency=" + frequency + ", " : "")
                + ((separator != null) ? "separator=" + separator + ", " : "")
                + ((sftpInfo != null) ? "sftpInfo=" + sftpInfo : "")
                + "]";
    }
}
